package jp.haw.grain.xpath;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import jp.haw.grain.dom.ElementWrapper;
import jp.haw.grain.transform.GudBuilder;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XPathByteCodeElement extends ElementWrapper implements XPathByteCodeElementInterface {

	public static final int CONTEXT_PARAM_SIZE = 0;
	public static final int CONTEXT_PARAM_POSITION = 1;
	
	public static final String XPATH_EXPR_ROOT_NODE_NAME = "xpath:expr";
	
	public static final String AXIS_ABSOLUTE = "absolute";
	public static final String AXIS_SELF = "self";
	public static final String AXIS_CHILD = "child";
	public static final String AXIS_PARENT = "parent";
	public static final String AXIS_ANCESTOR = "ancestor";
	public static final String AXIS_FOLLOWING = "following";
	public static final String AXIS_PRECEDING = "preceding";
	public static final String AXIS_ATTRIBUTE = "attribute";
	public static final String AXIS_NAMESPACE = "namespace";
	public static final String AXIS_DESCENDANT = "descendant";
	public static final String AXIS_ANCESTOR_OR_SELF = "ancestor-or-self";
	public static final String AXIS_DESCENDANT_OR_SELF = "descendant-or-self";
	public static final String AXIS_FOLLOWING_SIBLING = "following-sibling";
	public static final String AXIS_PRECEDING_SIBLING = "preceding-sibling";

	public static final Set AXIS_MAP;
	static {
		AXIS_MAP = new TreeSet();
		AXIS_MAP.add(AXIS_ABSOLUTE);
		AXIS_MAP.add(AXIS_SELF);
		AXIS_MAP.add(AXIS_CHILD);
		AXIS_MAP.add(AXIS_PARENT);
		AXIS_MAP.add(AXIS_ANCESTOR);
		AXIS_MAP.add(AXIS_FOLLOWING);
		AXIS_MAP.add(AXIS_PRECEDING);
		AXIS_MAP.add(AXIS_ATTRIBUTE);
		AXIS_MAP.add(AXIS_NAMESPACE);
		AXIS_MAP.add(AXIS_DESCENDANT);
		AXIS_MAP.add(AXIS_ANCESTOR_OR_SELF);
		AXIS_MAP.add(AXIS_DESCENDANT_OR_SELF);
		AXIS_MAP.add(AXIS_FOLLOWING_SIBLING);
		AXIS_MAP.add(AXIS_PRECEDING_SIBLING);
	}

	/*
	 * context parameter functions
	 */
    public static final String FUNC_POSITION = "position";
    public static final String FUNC_LAST = "last";    
    
    /*
     *  Trasration functions
     */
    public static final String FUNC_NUMBER = "number";
    public static final String FUNC_STRING = "string";    
    public static final String FUNC_BOOLEAN = "boolean";    
    
    /*
     *  Nodeset functions
     */
    public static final String FUNC_COUNT = "count";
    public static final String FUNC_ID = "id";

    /*
     * String functions
     */ 
    public static final String FUNC_CONCAT = "concat";
    public static final String FUNC_STARTS_WITH = "starts-with";
    public static final String FUNC_CONTAINS = "contains";
    public static final String FUNC_SUBSTRING_BEFORE = "substring-before";
    public static final String FUNC_SUBSTRING_AFTER = "substring-after";
    public static final String FUNC_SUBSTRING = "substring";
    public static final String FUNC_STRING_LENGTH = "string-length";
    public static final String FUNC_NORMALIZE_SPACE = "normalize-space";
    public static final String FUNC_TRANSLATE = "translate";
    
	protected int type;
	
	/**
	 * l킷oCgR[hGg𐶐ĕԂ܂B
	 * 
	 * @param str
	 *            oCgR[hɕϊl
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createStringValueElement(String str, Document doc) {
		XPathByteCodeElement stringElement = createValueElement("spush", doc);
		stringElement.setAttribute("_0", str);

		return stringElement;
	}

	/**
	 * l킷oCgR[hGg𐶐ĕԂ܂B
	 * 
	 * @param num
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createNumValueElement(int num, Document doc) {
		String str = "N" + String.valueOf(num);
		return createValueElement(str, doc);
	}

	/**
	 * _l킷oCgR[hGg𐶐ĕԂ܂B
	 * 
	 * @param bool
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createBooleanValueElement(boolean bool, Document doc) {
		String str = String.valueOf(bool);
		return createValueElement(str, doc);
	}

	/**
	 * Predicatel킷oCgR[hGg𐶐܂B
	 * 
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createPredicateElement(Document doc) {
		String str = "clspush";
		return createClosureElement(str, doc);
	}

	/**
	 * (Axis)l킷oCgR[hGg𐶐܂B axisValue̐擪"_"t܂B
	 * 
	 * @param axis
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createAxisElement(String axis, Document doc) {
		if(!XPathByteCodeElement.AXIS_MAP.contains(axis))
			throw new RuntimeException("Wrong axis name! :["+axis+"]");
		
		String str = "_" + axis;
		return createValueElement(str, doc);
	}

	/**
	 * Step߂킷oCgR[hGg𐶐܂B
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createStepElement(Document doc) {
		return createExprElement("step", doc);
	}

	/**
	 * ReLXgm[h[h߂킷oCgR[hGg𐶐܂B
	 * 
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createContextLoadElement(Document doc) {
		return createExprElement("ctxnload", doc);
	}

	/**
	 * ReLXgp[^[h߂킷oCgR[hGg𐶐܂B
	 * 
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createContextParamLoadElement(int index, Document doc) {
		if((index < 0) || (index > 2)) throw new RuntimeException("Wrong index!. indexi is 0 or 1: ["+index+"]");
		
		XPathByteCodeElement ctxpload = createExprElement("ctxpload", doc);
		ctxpload.setAttribute("_0", String.valueOf(index));
		return ctxpload;
	}

	/**
	 * predicates(filter)킷oCgR[hGg𐶐܂B
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createFilterElement(Document doc) {
		return createExprElement("filter", doc);
	}

	/**
	 * predicates(nfilter)킷oCgR[hGg𐶐܂B
	 * Ⴆhoge[2]predicateê݂̏ꍇɎg܂B
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createNFilterElement(Document doc) {
		return createExprElement("nfilter", doc);
	}

	/**
	 * ֐s(fcall)킷oCgR[hGg𐶐܂B
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createFcallElement(Document doc) {
		return createExprElement("fcall", doc);
	}

	/**
	 * jI( | )߂킷oCgR[hGg𐶐܂B
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createUnionElement(Document doc) {
		return createExprElement("union", doc);
	}

	/**
	 * And( and )߂킷oCgR[hGg𐶐܂B
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createAndElement(Document doc) {
		return createExprElement("and", doc);
	}

	/**
	 * Or( or )߂킷oCgR[hGg𐶐܂B
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createOrElement(Document doc) {
		return createExprElement("or", doc);
	}

	/**
	 * Equal( = )߂킷oCgR[hGg𐶐܂B
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createEqElement(Document doc) {
		return createExprElement("eq", doc);
	}

	/**
	 * NotEqual( != )߂킷oCgR[hGg𐶐܂B
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createNeElement(Document doc) {
		return createExprElement("ne", doc);
	}

	/**
	 * Lt( < )߂킷oCgR[hGg𐶐܂B
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createLtElement(Document doc) {
		return createExprElement("lt", doc);
	}

	/**
	 * Le( <= )߂킷oCgR[hGg𐶐܂B
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createLeElement(Document doc) {
		return createExprElement("le", doc);
	}

	/**
	 * Gt( > )߂킷oCgR[hGg𐶐܂B
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createGtElement(Document doc) {
		return createExprElement("gt", doc);
	}

	/**
	 * Ge( >= )߂킷oCgR[hGg𐶐܂B
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createGeElement(Document doc) {
		return createExprElement("ge", doc);
	}

	/**
	 * Add( + )߂킷oCgR[hGg𐶐܂B
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createAddElement(Document doc) {
		return createExprElement("add", doc);
	}

	/**
	 * Sub( - )߂킷oCgR[hGg𐶐܂B
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createSubElement(Document doc) {
		return createExprElement("sub", doc);
	}

	/**
	 * Div( / )߂킷oCgR[hGg𐶐܂B
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createDivElement(Document doc) {
		return createExprElement("div", doc);
	}

	/**
	 * Mult( * )߂킷oCgR[hGg𐶐܂B
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createMultElement(Document doc) {
		return createExprElement("mult", doc);
	}

	/**
	 * Mod( % )߂킷oCgR[hGg𐶐܂B
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createModElement(Document doc) {
		return createExprElement("mod", doc);
	}

	/**
	 * Neg( l̔] )߂킷oCgR[hGg𐶐܂B
	 * @param doc
	 * @return
	 */
	public static XPathByteCodeElement createNegElement( Document doc) {
		return createExprElement("neg", doc);
	}

	private static XPathByteCodeElement createValueElement(String name, Document doc) {
		return new XPathByteCodeElement(doc.createElementNS(GudBuilder.XPATH_NS, GudBuilder.XPATH_PREFIX+":"+name), XPathByteCodeElementInterface.BYTE_CODE_TYPE_VALUE);
	}
	
	private static XPathByteCodeElement createExprElement(String name, Document doc) {
		return new XPathByteCodeElement(doc.createElementNS(GudBuilder.XPATH_NS, GudBuilder.XPATH_PREFIX+":"+name), XPathByteCodeElementInterface.BYTE_CODE_TYPE_EXPR);
	}

	private static XPathByteCodeElement createClosureElement(String name, Document doc) {
		return new XPathByteCodeElement(doc.createElementNS(GudBuilder.XPATH_NS, GudBuilder.XPATH_PREFIX+":"+name), XPathByteCodeElementInterface.BYTE_CODE_TYPE_CLOSURE);
	}
	

	private XPathByteCodeElement(Element e, int elementType) {
		super(e);
		this.type = elementType;
	}

	public int getByteCodeType() {
		return this.type;
	}

}
