/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.greflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import jp.sourceforge.greflect.Param;
import jp.sourceforge.greflect.ReflectionError;
import jp.sourceforge.greflect.TypeViolationException;
import jp.sourceforge.greflect.impl.BytecodeGeneratorClassLoader;
import jp.sourceforge.greflect.impl.ChainedTypeVarScope;
import jp.sourceforge.greflect.impl.ClassTypeVarScope;
import jp.sourceforge.greflect.impl.DefaultTypeConversionStrategy;
import jp.sourceforge.greflect.impl.TypeConversionStrategy;
import jp.sourceforge.greflect.impl.TypeVarScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflection {
    TypeConversionStrategy strategy = new DefaultTypeConversionStrategy();
    BytecodeGeneratorClassLoader classLoader = new BytecodeGeneratorClassLoader(Instantiator.class.getClassLoader());
    private final Field invokerReturnValueField;
    private final Field instantiatorReturnValueField;
    private final Field casterReturnValueField;

    public Reflection() {
        this(Reflection.class.getClassLoader());
    }

    public Reflection(ClassLoader class_loader) {
        Field fi = null;
        Field fv = null;
        Field fc = null;
        try {
            fi = Invoker.class.getDeclaredField("returnValue");
            fv = Instantiator.class.getDeclaredField("returnValue");
            fc = Caster.class.getDeclaredField("returnValue");
        }
        catch (Exception ex) {
            ExceptionInInitializerError e = new ExceptionInInitializerError(ex);
            throw e;
        }
        finally {
            this.invokerReturnValueField = fi;
            this.instantiatorReturnValueField = fv;
            this.casterReturnValueField = fc;
        }
        this.classLoader = new BytecodeGeneratorClassLoader(class_loader);
    }

    public boolean isAssignableFromTo(Param<?> from, Param<?> to) throws TypeViolationException {
        return this.strategy.isAssignableFromTo(from.getType(), from.getTypeVarScope(), to.getType(), to.getTypeVarScope());
    }

    public String getTypeDescriptionFor(Param<?> caster) throws TypeViolationException {
        return this.strategy.getTypeDescriptionFor(caster.getType(), caster.getTypeVarScope(), true);
    }

    private Method findMethod(Param<?> instance, String methodName, Param<?> ... args) throws TypeViolationException, NoSuchMethodException, SecurityException {
        Class<?> cls = this.strategy.getRawClassOf(instance.getType(), instance.getTypeVarScope());
        Method[] ms = cls.getMethods();
        Class[][] msp = new Class[ms.length][];
        int i = ms.length;
        while (--i >= 0) {
            if (!ms[i].getName().equals(methodName)) continue;
            msp[i] = ms[i].getParameterTypes();
        }
        return this.findMostSpecificT(cls, methodName, args, ms, msp);
    }

    private Constructor findConstructor(Type type, TypeVarScope scope, Param<?>[] args) throws TypeViolationException, NoSuchMethodException, SecurityException {
        Class<?> rc = this.strategy.getRawClassOf(type, scope);
        Constructor<?>[] ms = rc.getConstructors();
        Class[][] msp = new Class[ms.length][];
        int i = ms.length;
        while (--i >= 0) {
            msp[i] = ms[i].getParameterTypes();
        }
        return this.findMostSpecificT(rc, "<init>", args, ms, msp);
    }

    private <T> T findMostSpecificT(Class iclass, String methodName, Param<?>[] args, T[] ms, Class<?>[][] msp) throws TypeViolationException, NoSuchMethodException, SecurityException {
        Class[] clss = new Class[args.length];
        int i = args.length;
        while (--i >= 0) {
            Type atype = args[i].getType();
            TypeVarScope ascope = ClassTypeVarScope.getTypeScopeWithEnclosings(args[i].getClass());
            clss[i] = this.strategy.getRawClassOf(atype, ascope);
        }
        T msm = null;
        Class<?>[] mpts = null;
        int i2 = ms.length;
        while (--i2 >= 0) {
            T m = ms[i2];
            Class<?>[] pts = msp[i2];
            if (pts == null || !this.isAssignable(pts, clss)) continue;
            if (msm == null || this.isAssignable(mpts, pts)) {
                msm = m;
                mpts = pts;
                continue;
            }
            throw new TypeViolationException("The methods/constructors ''{0}'' and ''{1}'' is matched. Fix the signature to invoke.", msm, m);
        }
        if (msm != null) {
            return msm;
        }
        StringBuilder mes = new StringBuilder();
        mes.append("There is no suitable method to ");
        mes.append(iclass);
        mes.append(" ");
        mes.append(methodName);
        mes.append("(");
        for (Class c : clss) {
            mes.append(c.getName());
        }
        mes.append(").");
        throw new NoSuchMethodException(mes.toString());
    }

    private boolean isAssignable(Class<?>[] to, Class<?>[] from) {
        if (to.length != from.length) {
            return false;
        }
        int i = to.length;
        while (--i >= 0) {
            if (this.strategy.isAssignableFromTo(from[i], to[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Caster<T> {
        private T returnValue = null;

        public Caster(Object instance) throws TypeViolationException {
            try {
                Reflection.this.casterReturnValueField.set(this, instance);
            }
            catch (IllegalAccessException ex) {
                throw new ReflectionError(ex, "IllegalAccessException has not prechecked. Report as a bug.", new Object[0]);
            }
        }

        public T cast() {
            return this.returnValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Invoker<T> {
        private final Object instance;
        private final Method method;
        private final Object[] methodArgs;
        private T returnValue = null;

        public Invoker(Param<?> instance, String methodName, Param<?> ... args) throws TypeViolationException, NoSuchMethodException, SecurityException, IllegalAccessException {
            this(instance, reflection.findMethod(instance, methodName, args), args);
        }

        /*
         * Enabled aggressive block sorting
         */
        public Invoker(Param<?> instance, Method method, Param<?> ... args) throws TypeViolationException, IllegalArgumentException, IllegalAccessException {
            TypeVarScope cscope;
            if (Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException("Static methods cannot be specified.");
            }
            this.instance = instance.getValue();
            this.method = method;
            TypeVarScope iscope = instance.getTypeVarScope();
            Type[] iprmtps = method.getGenericParameterTypes();
            if (iprmtps.length != args.length) {
                throw new IllegalArgumentException("The specified parameter has '" + args.length + "' parameters though the constructor has '" + iprmtps.length + "' parameters. Revise the specification.");
            }
            Class<?> cclass = method.getDeclaringClass();
            Type type = Reflection.this.strategy.resolveTypeVariable(instance.getType(), iscope);
            if (type instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)type;
                if (!cclass.equals(pt.getRawType())) {
                    String src = Reflection.this.strategy.getTypeDescriptionFor(type, iscope, true);
                    throw new TypeViolationException("The specified type ''{0}'' is not declaring the method ''{1}''. Revise the specification.", src, method);
                }
                Type[] tps = pt.getActualTypeArguments();
                cscope = ChainedTypeVarScope.chain(iscope, cclass, tps);
            } else {
                cscope = iscope;
            }
            int i = iprmtps.length;
            while (--i >= 0) {
                TypeVarScope ascope;
                Type itype = iprmtps[i];
                Type atype = args[i].getType();
                if (Reflection.this.strategy.isAssignableFromTo(atype, ascope = args[i].getTypeVarScope(), itype, cscope)) continue;
                String src = Reflection.this.strategy.getTypeDescriptionFor(atype, ascope, true);
                String dst = Reflection.this.strategy.getTypeDescriptionFor(itype, cscope, true);
                throw new TypeViolationException("The specified type ''{0}'' is not applicable for the param{1} type ''{2}'' of the method {3}. Revise the specification.", src, i, dst, method);
            }
            TypeVarScope rscope = ClassTypeVarScope.getTypeScopeWithEnclosings(this.getClass());
            Type rtype = this.getType();
            Type irtype = method.getGenericReturnType();
            if (!Void.TYPE.equals(irtype) && !Reflection.this.strategy.isAssignableFromTo(irtype, cscope, rtype, rscope)) {
                String src = Reflection.this.strategy.getTypeDescriptionFor(irtype, cscope, true);
                String dst = Reflection.this.strategy.getTypeDescriptionFor(rtype, rscope, true);
                throw new TypeViolationException("The specified type ''{0}'' is not applicable for the return type ''{1}'' of the method {2}. Revise the type.", dst, src, method);
            }
            Object[] values = new Object[iprmtps.length];
            int i2 = iprmtps.length;
            while (true) {
                if (--i2 < 0) {
                    this.methodArgs = values;
                    return;
                }
                Object av = args[i2].getValue();
                values[i2] = av;
            }
        }

        public T invoke() throws InvocationTargetException {
            try {
                Object r = this.method.invoke(this.instance, this.methodArgs);
                Reflection.this.invokerReturnValueField.set(this, r);
                return this.returnValue;
            }
            catch (IllegalAccessException ex) {
                throw new ReflectionError(ex, "IllegalAccessException has not prechecked. Report as a bug.", new Object[0]);
            }
        }

        Type getType() throws TypeViolationException {
            return Invoker.class.getTypeParameters()[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Instantiator<T> {
        private final Object[] constructorArgs;
        private final Constructor<?> constructor;
        private T returnValue = null;

        public Instantiator(Param<?> instype, Param<?> ... args) throws SecurityException, ClassNotFoundException, TypeViolationException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException {
            this(instype, reflection.findConstructor(instype.getType(), instype.getTypeVarScope(), args), args);
        }

        /*
         * Enabled aggressive block sorting
         */
        public Instantiator(Param<?> instype, Constructor<?> cst, Param<?> ... args) throws SecurityException, ClassNotFoundException, TypeViolationException, IllegalArgumentException, IllegalAccessException {
            TypeVarScope s;
            TypeVariable t;
            TypeVarScope cscope;
            Type type = instype.getType();
            TypeVarScope iscope = instype.getTypeVarScope();
            Class<?> cclass = cst.getDeclaringClass();
            type = Reflection.this.strategy.resolveTypeVariable(type, iscope);
            if (type instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)type;
                if (!cclass.equals(pt.getRawType())) {
                    String src = Reflection.this.strategy.getTypeDescriptionFor(type, iscope, true);
                    throw new TypeViolationException("The specified type ''{0}'' is not declaring the constructor ''{1}''. Revise the specification.", src, cst);
                }
                Type[] tps = pt.getActualTypeArguments();
                cscope = ChainedTypeVarScope.chain(iscope, cclass, tps);
            } else {
                cscope = iscope;
            }
            if (!Reflection.this.strategy.isAssignableFromTo(cclass, cscope, t = Instantiator.class.getTypeParameters()[0], s = ClassTypeVarScope.getTypeScopeWithEnclosings(this.getClass()))) {
                String src = Reflection.this.strategy.getTypeDescriptionFor(t, s, true);
                String dst = Reflection.this.strategy.getTypeDescriptionFor(cclass, cscope, true);
                throw new TypeViolationException("The specified type ''{0}'' is not suitable to set the created object of ''{1}''. Revise the specification.", src, dst);
            }
            if (!Reflection.this.strategy.isAssignableFromTo(type, iscope, cclass, cscope)) {
                String src = Reflection.this.strategy.getTypeDescriptionFor(type, iscope, true);
                throw new TypeViolationException("The specified type ''{0}'' is not declaring the constructor ''{1}''. Revise the specification.", src, cst);
            }
            Type[] iprmtps = cst.getGenericParameterTypes();
            if (iprmtps.length != args.length) {
                throw new IllegalArgumentException("The specified parameter has '" + args.length + "' parameters though the constructor has '" + iprmtps.length + "' parameters. Revise the specification.");
            }
            int i = args.length;
            while (--i >= 0) {
                TypeVarScope ascope;
                Type itype = iprmtps[i];
                Type atype = args[i].getType();
                if (Reflection.this.strategy.isAssignableFromTo(atype, ascope = args[i].getTypeVarScope(), itype, cscope)) continue;
                String src = Reflection.this.strategy.getTypeDescriptionFor(atype, ascope, true);
                String dst = Reflection.this.strategy.getTypeDescriptionFor(itype, cscope, true);
                throw new TypeViolationException("The specified type ''{0}'' is not applicable for the param{1} type ''{2}'' of the constructor {3}. Revise the specification.", src, i, dst, cst);
            }
            String gsig = Reflection.this.strategy.getTypeSignatureTo(type, iscope);
            Constructor<?> icst = Reflection.this.classLoader.generateClassAndGetConstructorFor(cst, gsig);
            Object[] values = new Object[args.length];
            int i2 = args.length;
            while (true) {
                if (--i2 < 0) {
                    this.constructor = icst;
                    this.constructorArgs = values;
                    return;
                }
                Object av = args[i2].getValue();
                values[i2] = av;
            }
        }

        public T instantiate() throws InvocationTargetException {
            try {
                Object r = this.constructor.newInstance(this.constructorArgs);
                Reflection.this.instantiatorReturnValueField.set(this, r);
                return this.returnValue;
            }
            catch (InstantiationException ex) {
                throw new ReflectionError(ex, "InstantiationException has not prechecked. Report as a bug.", new Object[0]);
            }
            catch (IllegalAccessException ex) {
                throw new ReflectionError(ex, "IllegalAccessException has not prechecked. Report as a bug.", new Object[0]);
            }
        }
    }
}

