/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.greflect.impl;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sourceforge.greflect.TypeViolationException;
import jp.sourceforge.greflect.UnresolvedTypeVariableException;
import jp.sourceforge.greflect.impl.ChainedTypeVarScope;
import jp.sourceforge.greflect.impl.GenericTypeRef;
import jp.sourceforge.greflect.impl.TypeConversionStrategy;
import jp.sourceforge.greflect.impl.TypeVarScope;
import jp.sourceforge.greflect.impl.TypeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTypeConversionStrategy
implements TypeConversionStrategy {
    final boolean simpleTypeDescription = true;
    Logger log = Logger.global;
    final Map<Class<?>, Prim> primMap;

    public DefaultTypeConversionStrategy() {
        this.log.setLevel(Level.WARNING);
        HashMap<Class<Object>, Prim> map = new HashMap<Class<Object>, Prim>(32);
        map.put(Boolean.TYPE, Prim.BOOLEAN_P);
        map.put(Byte.TYPE, Prim.BYTE_P);
        map.put(Character.TYPE, Prim.CHAR_P);
        map.put(Short.TYPE, Prim.SHORT_P);
        map.put(Integer.TYPE, Prim.INT_P);
        map.put(Long.TYPE, Prim.LONG_P);
        map.put(Float.TYPE, Prim.FLOAT_P);
        map.put(Double.TYPE, Prim.DOUBLE_P);
        map.put(Void.TYPE, Prim.VOID_P);
        map.put(Boolean.class, Prim.BOOLEAN_W);
        map.put(Byte.class, Prim.BYTE_W);
        map.put(Character.class, Prim.CHAR_W);
        map.put(Short.class, Prim.SHORT_W);
        map.put(Integer.class, Prim.INT_W);
        map.put(Long.class, Prim.LONG_W);
        map.put(Float.class, Prim.FLOAT_W);
        map.put(Double.class, Prim.DOUBLE_W);
        map.put(Void.class, Prim.VOID_W);
        this.primMap = Collections.unmodifiableMap(map);
    }

    private Type resolveAndCheckTypeVariable(Type type, TypeVarScope scope) throws TypeViolationException {
        Type t = this.resolveTypeVariable(type, scope);
        if (t instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)t;
            String tname = tv.getGenericDeclaration() + ":" + tv.getName();
            throw new UnresolvedTypeVariableException("The type variable ''{0}'' cannot be resolved in the scope ''{1}''. Use ungeneric tecnique.", tname, scope);
        }
        return t;
    }

    @Override
    public Type resolveTypeVariable(Type type, TypeVarScope scope) {
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            if (scope != null) {
                GenericTypeRef gtr = scope.resolveTypeVariable(tv);
                if (gtr == null) {
                    return type;
                }
                Type ft = gtr.getType();
                return this.resolveTypeVariable(ft, scope);
            }
            throw new NullPointerException("scope");
        }
        return type;
    }

    @Override
    public Class<?> getRawClassOf(Type type, TypeVarScope scope) throws TypeViolationException {
        Type t = this.resolveTypeVariable(type, scope);
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            Type rt = ((ParameterizedType)t).getRawType();
            if (rt instanceof Class) {
                return (Class)rt;
            }
            throw new TypeViolationException("The raw of type variable ''{0}'' must be a Class to find the method to invoke. Revise the type variable.", this.getTypeDescriptionFor(type, scope, false));
        }
        throw new TypeViolationException("The type variable ''{0}'' must be a Class or a parameterized Class but ''{1}''. Revise the type variable.", this.getTypeDescriptionFor(type, scope, false), t == null ? t : t.getClass().getName());
    }

    @Override
    public boolean isAssignableFromTo(Class<?> from, Class<?> to) {
        if (from.isPrimitive() || to.isPrimitive()) {
            Prim sp = this.getPrim(from);
            Prim dp = this.getPrim(to);
            return dp.isAssignableFrom(sp);
        }
        return to.isAssignableFrom(from);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAssignableFromTo(Type stype, TypeVarScope sscope, Type dtype, TypeVarScope dscope) throws TypeViolationException {
        Type r;
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            String mes = "isAssignable:" + stype + " in " + sscope + " -> " + dtype + " in " + dscope;
            this.log.log(Level.INFO, mes);
        }
        if (stype == null) {
            throw new NullPointerException("stype");
        }
        if (dtype == null) {
            throw new NullPointerException("dtype");
        }
        stype = this.resolveAndCheckTypeVariable(stype, sscope);
        dtype = this.resolveAndCheckTypeVariable(dtype, dscope);
        Type[] sps = null;
        Type[] dps = null;
        Class src = null;
        Class drc = null;
        if (dtype instanceof Class) {
            drc = (Class)dtype;
            dps = drc.getTypeParameters();
        } else {
            if (!(dtype instanceof ParameterizedType)) throw new TypeViolationException("The type ''{0}'' is not supported now.", dtype);
            ParameterizedType dt = (ParameterizedType)dtype;
            r = dt.getRawType();
            if (!(r instanceof Class)) throw new TypeViolationException("The raw type of parameterized type ''{0}'' is not a Class. Revise the type variable.", dtype);
            drc = (Class)r;
            dps = dt.getActualTypeArguments();
        }
        if (stype instanceof Class) {
            src = (Class)stype;
            sps = src.getTypeParameters();
        } else {
            if (!(stype instanceof ParameterizedType)) throw new TypeViolationException("The type ''{0}'' is not supported now.", stype);
            ParameterizedType st = (ParameterizedType)stype;
            r = st.getRawType();
            if (!(r instanceof Class)) throw new TypeViolationException("The raw type of parameterized type ''{0}'' is not a Class. Revise the type variable.", stype);
            src = (Class)r;
            sps = st.getActualTypeArguments();
        }
        assert (dps != null);
        assert (drc != null);
        assert (sps != null);
        assert (src != null);
        if (dps.length == 0 && sps.length == 0) {
            if (!src.isPrimitive() && !drc.isPrimitive()) return drc.isAssignableFrom(src);
            Prim sp = this.getPrim(src);
            Prim dp = this.getPrim(drc);
            if (this.log == null || !this.log.isLoggable(Level.INFO)) return dp.isAssignableFrom(sp);
            this.log.log(Level.INFO, "getPrim():" + (Object)((Object)sp) + " -> " + (Object)((Object)dp));
            return dp.isAssignableFrom(sp);
        }
        if (!drc.equals(src)) return this.isAssignableStage2(stype, sscope, dtype, dscope);
        int i = sps.length;
        while (--i >= 0 && (dps.length != sps.length || this.isMatchedForAssignment(sps[i], sscope, dps[i], dscope))) {
        }
        if (i >= 0) return this.isAssignableStage2(stype, sscope, dtype, dscope);
        return true;
    }

    private boolean isAssignableStage2(Type stype, TypeVarScope sscope, Type dtype, TypeVarScope dscope) throws TypeViolationException {
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.log(Level.INFO, "isAssignableStage2:" + stype + " in " + sscope + " -> " + dtype + " in " + dscope);
        }
        if (stype == null) {
            throw new NullPointerException("stype");
        }
        if (dtype == null) {
            throw new NullPointerException("dtype");
        }
        if (Object.class.equals((Object)dtype)) {
            return true;
        }
        if (stype instanceof Class) {
            Class c = (Class)stype;
            Type st = c.getGenericSuperclass();
            if (st != null && this.isAssignableFromTo(st, sscope, dtype, dscope)) {
                return true;
            }
            Type[] ifs = c.getGenericInterfaces();
            for (int i = 0; i < ifs.length; ++i) {
                if (!this.isAssignableFromTo(ifs[i], sscope, dtype, dscope)) continue;
                return true;
            }
            return false;
        }
        if (stype instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)stype;
            Type st = pt.getRawType();
            if (st instanceof Class) {
                Type[] ps = pt.getActualTypeArguments();
                Class sc = (Class)st;
                TypeVarScope cscp = ChainedTypeVarScope.chain(sscope, sc, ps);
                return this.isAssignableStage2(sc, cscp, dtype, dscope);
            }
            throw new TypeViolationException("The raw type of parameterized type ''{0}'' is not a Class. Revise the type variable.", st);
        }
        if (stype instanceof WildcardType) {
            throw new TypeViolationException("The wildcard type ''{0}'' is unsupported now. Revise the type variable.", stype);
        }
        if (stype instanceof TypeVariable) {
            throw new TypeViolationException("The type variable ''{0}'' cannot be the target for substitution. Revise the type variable.", stype);
        }
        throw new TypeViolationException("The type ''{0}'' is unsupported now. Revise the type variable.", stype);
    }

    private boolean isMatchedForAssignment(Type stype, TypeVarScope sscope, Type dtype, TypeVarScope dscope) throws TypeViolationException {
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.log(Level.INFO, "isMatchedForAssignment:" + stype + " in " + sscope + " -> " + dtype + " in " + dscope);
        }
        if (stype == null) {
            throw new NullPointerException("stype");
        }
        if (dtype == null) {
            throw new NullPointerException("dtype");
        }
        stype = this.resolveAndCheckTypeVariable(stype, sscope);
        if ((dtype = this.resolveAndCheckTypeVariable(dtype, dscope)) instanceof Class) {
            Class dc = (Class)dtype;
            TypeVariable<Class<T>>[] tvs = dc.getTypeParameters();
            if (tvs.length > 0) {
                throw new TypeViolationException("The ''{0}'' have type variables. Use ungeneric tecnique.", dtype);
            }
            if (stype instanceof Class) {
                Class st = (Class)stype;
                if (st.getTypeParameters().length > 0) {
                    throw new TypeViolationException("The ''{0}'' have type variables. Use ungeneric tecnique.", stype);
                }
                return dc.equals(st);
            }
            return false;
        }
        if (dtype instanceof ParameterizedType) {
            ParameterizedType dt = (ParameterizedType)dtype;
            if (stype instanceof ParameterizedType) {
                Type[] das;
                Type[] sas;
                ParameterizedType st = (ParameterizedType)stype;
                Type sr = st.getRawType();
                Type dr = dt.getRawType();
                if (!(sr instanceof Class)) {
                    throw new TypeViolationException("The raw type of parameterized type ''{0}'' is not a Class. Revise the type variable.", st);
                }
                if (!(dr instanceof Class)) {
                    throw new TypeViolationException("The raw type of parameterized type ''{0}'' is not a Class. Revise the type variable.", dt);
                }
                if (sr.equals(dr) && (sas = st.getActualTypeArguments()).length == (das = dt.getActualTypeArguments()).length) {
                    int i = sas.length;
                    while (--i >= 0 && this.isMatchedForAssignment(sas[i], sscope, das[i], dscope)) {
                    }
                    if (i < 0) {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
        if (dtype instanceof WildcardType) {
            WildcardType dt = (WildcardType)dtype;
            Type[] lbs = dt.getLowerBounds();
            if (lbs != null && lbs.length != 0) {
                throw new TypeViolationException("The type ''{0}'' with lower bounds is unsupported. Revise the type variable.", dtype);
            }
            Type[] ubs = dt.getUpperBounds();
            if (ubs != null && ubs.length == 1 && !Object.class.equals((Object)ubs[0])) {
                throw new TypeViolationException("The type ''{0}'' with upper bounds is unsupported. Revise the type variable.", dtype);
            }
            return true;
        }
        if (dtype instanceof TypeVariable) {
            throw new UnsupportedOperationException();
        }
        throw new TypeViolationException("The type ''{0}'' is unsupported. Revise the type variable.", dtype);
    }

    @Override
    public String getTypeDescriptionFor(Type type, TypeVarScope scope, boolean ignoreTypeName) {
        StringBuilder buf = new StringBuilder();
        this.writeTypeDescriptionTo(buf, type, scope, ignoreTypeName);
        return buf.toString();
    }

    @Override
    public void writeTypeDescriptionTo(StringBuilder buf, Type type, TypeVarScope scope, boolean ignoreTypeName) {
        if (buf == null) {
            throw new IllegalArgumentException("buf");
        }
        if (type == null) {
            buf.append("null");
            return;
        }
        if (type instanceof Class) {
            Class dc = (Class)type;
            buf.append(dc.getSimpleName());
            TypeVariable<Class<T>>[] tvs = dc.getTypeParameters();
            if (tvs.length > 0) {
                buf.append('<');
                for (int i = 0; i < tvs.length; ++i) {
                    if (i > 0) {
                        buf.append(',');
                    }
                    TypeVariable tv = tvs[i];
                    buf.append(tv.getName());
                    Type t = this.resolveTypeVariable(tv, scope);
                    if (t instanceof TypeVariable) {
                        TypeVariable rt = (TypeVariable)t;
                        this.writeTypeVariableTo(buf, rt, ignoreTypeName);
                        continue;
                    }
                    buf.append('=');
                    this.writeTypeDescriptionTo(buf, t, scope, ignoreTypeName);
                }
                buf.append('>');
            }
        } else if (type instanceof TypeVariable) {
            Type t;
            TypeVariable dt = (TypeVariable)type;
            if (!ignoreTypeName) {
                Object gd = dt.getGenericDeclaration();
                if (gd instanceof Class) {
                    buf.append(((Class)gd).getSimpleName());
                } else if (gd instanceof Method) {
                    buf.append(((Method)gd).getName());
                } else {
                    buf.append(gd.toString());
                }
                buf.append(':');
                buf.append(dt.getName());
                buf.append('=');
            }
            if ((t = this.resolveTypeVariable(type, scope)) instanceof TypeVariable) {
                TypeVariable rt = (TypeVariable)t;
                this.writeTypeVariableTo(buf, rt, ignoreTypeName);
            } else {
                this.writeTypeDescriptionTo(buf, t, scope, ignoreTypeName);
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType dt = (ParameterizedType)type;
            Type dr = dt.getRawType();
            if (dr instanceof Class) {
                buf.append(((Class)dr).getSimpleName());
            } else {
                buf.append(dr.toString());
            }
            buf.append('<');
            Type[] das = dt.getActualTypeArguments();
            for (int i = 0; i < das.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                Type t = das[i];
                this.writeTypeDescriptionTo(buf, t, scope, ignoreTypeName);
            }
            buf.append('>');
        } else if (type instanceof WildcardType) {
            buf.append(type.toString());
        } else {
            if (type instanceof TypeVariable) {
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }
    }

    private void writeTypeVariableTo(StringBuilder buf, TypeVariable<?> rt, boolean ignoreTypeName) {
        if (!ignoreTypeName) {
            Object gd = rt.getGenericDeclaration();
            if (gd instanceof Class) {
                buf.append(((Class)gd).getSimpleName());
            } else if (gd instanceof Method) {
                buf.append(((Method)gd).getName());
            } else {
                buf.append(gd.toString());
            }
            buf.append(':');
        }
        buf.append(rt.getName());
    }

    private Prim getPrim(Class<?> c) {
        Prim p = this.primMap.get(c);
        return p != null ? p : Prim.NONE;
    }

    @Override
    public String getTypeSignatureTo(Type type, final TypeVarScope scope) throws TypeViolationException {
        final StringBuilder body = new StringBuilder();
        TypeVisitor<Integer> v = new TypeVisitor<Integer>(){

            private void writeClassnameTo(StringBuilder b, String name) {
                int n = name.length();
                for (int i = 0; i < n; ++i) {
                    char c = name.charAt(i);
                    if (c == '.') {
                        b.append('/');
                        continue;
                    }
                    b.append(c);
                }
            }

            @Override
            public Integer visit(Class type) throws TypeViolationException {
                if (type.isPrimitive()) {
                    return this.visitSusupportedType(type);
                }
                body.append('L');
                this.writeClassnameTo(body, type.getName());
                body.append(';');
                return null;
            }

            @Override
            public Integer visit(TypeVariable<?> type) throws TypeViolationException {
                GenericTypeRef gtr = scope.resolveTypeVariable(type);
                if (gtr == null) {
                    throw new TypeViolationException("The instanciation fails because type variable ''{0}'' is not resolved. Revise the specitication.", type);
                }
                return (Integer)this.visit(gtr.getType());
            }

            @Override
            public Integer visit(ParameterizedType type) throws TypeViolationException {
                Type rt = type.getRawType();
                Type[] ps = type.getActualTypeArguments();
                if (rt instanceof Class) {
                    body.append('L');
                    this.writeClassnameTo(body, ((Class)rt).getName());
                    body.append('<');
                    for (int i = 0; i < ps.length; ++i) {
                        this.visit(ps[i]);
                    }
                    body.append('>');
                    body.append(';');
                    return null;
                }
                return this.visitSusupportedType(type);
            }

            @Override
            public Integer visit(WildcardType type) throws TypeViolationException {
                throw new TypeViolationException("The instanciation of type ''{0}'' is not supported. Revise the specitication.", type);
            }

            @Override
            public Integer visit(GenericArrayType type) throws TypeViolationException {
                body.append('[');
                return (Integer)this.visit(type.getGenericComponentType());
            }

            @Override
            public Integer visitSusupportedType(Type type) throws TypeViolationException {
                throw new TypeViolationException("The instanciation of type ''{0}'' is not supported. Report it as a bug.", type);
            }
        };
        v.visit(type);
        return body.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Prim {
        NONE{

            boolean isAssignableFrom(Prim p) {
                return false;
            }
        }
        ,
        BOOLEAN_P{

            boolean isAssignableFrom(Prim p) {
                return boolean_p.contains((Object)p);
            }
        }
        ,
        BOOLEAN_W{

            boolean isAssignableFrom(Prim p) {
                return boolean_w.contains((Object)p);
            }
        }
        ,
        BYTE_P{

            boolean isAssignableFrom(Prim p) {
                return byte_p.contains((Object)p);
            }
        }
        ,
        BYTE_W{

            boolean isAssignableFrom(Prim p) {
                return byte_w.contains((Object)p);
            }
        }
        ,
        CHAR_P{

            boolean isAssignableFrom(Prim p) {
                return char_p.contains((Object)p);
            }
        }
        ,
        CHAR_W{

            boolean isAssignableFrom(Prim p) {
                return char_w.contains((Object)p);
            }
        }
        ,
        SHORT_P{

            boolean isAssignableFrom(Prim p) {
                return short_p.contains((Object)p);
            }
        }
        ,
        SHORT_W{

            boolean isAssignableFrom(Prim p) {
                return short_w.contains((Object)p);
            }
        }
        ,
        INT_P{

            boolean isAssignableFrom(Prim p) {
                return int_p.contains((Object)p);
            }
        }
        ,
        INT_W{

            boolean isAssignableFrom(Prim p) {
                return int_w.contains((Object)p);
            }
        }
        ,
        LONG_P{

            boolean isAssignableFrom(Prim p) {
                return long_p.contains((Object)p);
            }
        }
        ,
        LONG_W{

            boolean isAssignableFrom(Prim p) {
                return long_w.contains((Object)p);
            }
        }
        ,
        FLOAT_P{

            boolean isAssignableFrom(Prim p) {
                return float_p.contains((Object)p);
            }
        }
        ,
        FLOAT_W{

            boolean isAssignableFrom(Prim p) {
                return float_w.contains((Object)p);
            }
        }
        ,
        DOUBLE_P{

            boolean isAssignableFrom(Prim p) {
                return double_p.contains((Object)p);
            }
        }
        ,
        DOUBLE_W{

            boolean isAssignableFrom(Prim p) {
                return double_w.contains((Object)p);
            }
        }
        ,
        VOID_P{

            boolean isAssignableFrom(Prim p) {
                return false;
            }
        }
        ,
        VOID_W{

            boolean isAssignableFrom(Prim p) {
                return p == this;
            }
        };

        static final EnumSet<Prim> boolean_p;
        static final EnumSet<Prim> boolean_w;
        static final EnumSet<Prim> byte_p;
        static final EnumSet<Prim> byte_w;
        static final EnumSet<Prim> char_p;
        static final EnumSet<Prim> char_w;
        static final EnumSet<Prim> short_p;
        static final EnumSet<Prim> short_w;
        static final EnumSet<Prim> int_p;
        static final EnumSet<Prim> int_w;
        static final EnumSet<Prim> long_p;
        static final EnumSet<Prim> long_w;
        static final EnumSet<Prim> float_p;
        static final EnumSet<Prim> float_w;
        static final EnumSet<Prim> double_p;
        static final EnumSet<Prim> double_w;

        abstract boolean isAssignableFrom(Prim var1);

        static {
            boolean_w = EnumSet.of(BOOLEAN_P, BOOLEAN_W);
            boolean_p = boolean_w;
            byte_w = EnumSet.of(BYTE_P, BYTE_W);
            char_w = EnumSet.of(CHAR_P, CHAR_W);
            short_w = EnumSet.of(SHORT_P, SHORT_W);
            int_w = EnumSet.of(INT_P, INT_W);
            long_w = EnumSet.of(LONG_P, LONG_W);
            float_w = EnumSet.of(FLOAT_P, FLOAT_W);
            double_w = EnumSet.of(DOUBLE_P, DOUBLE_W);
            byte_p = byte_w;
            char_p = char_w;
            short_p = EnumSet.copyOf(short_w);
            short_p.addAll(byte_p);
            int_p = EnumSet.copyOf(int_w);
            int_p.addAll(short_p);
            int_p.addAll(char_p);
            long_p = EnumSet.copyOf(long_w);
            long_p.addAll(int_p);
            float_p = EnumSet.copyOf(float_w);
            float_p.addAll(long_p);
            double_p = EnumSet.copyOf(double_w);
            double_p.addAll(float_p);
        }
    }
}

