/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.greflect.impl;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import jp.sourceforge.greflect.TypeViolationException;
import jp.sourceforge.greflect.impl.BranchedTypeVarScope;
import jp.sourceforge.greflect.impl.GenericTypeRef;
import jp.sourceforge.greflect.impl.SimpleGenericTypeRef;
import jp.sourceforge.greflect.impl.TypeVarScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractingTypeVarScope
implements TypeVarScope {
    private final TypeVarMap typeVarMap;

    public static TypeVarScope makeMargedScope(Type type, TypeVarScope scope) throws TypeViolationException {
        ExtractingTypeVarScope r = new ExtractingTypeVarScope(type, scope);
        return new BranchedTypeVarScope(r, scope);
    }

    public ExtractingTypeVarScope(Type type, TypeVarScope scope) throws TypeViolationException {
        if (type == null) {
            throw new NullPointerException("cls");
        }
        TypeVarMap map = new TypeVarMap();
        ExtractingTypeVarScope.garbageTypeVarsStage1(map, type, scope);
        this.typeVarMap = map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void garbageTypeVarsStage1(TypeVarMap map, Type type, TypeVarScope scope) throws TypeViolationException {
        if (type instanceof Class) return;
        if (type instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)type;
            Type rtr = t.getRawType();
            Type[] ptps = t.getActualTypeArguments();
            if (!(rtr instanceof Class)) throw new TypeViolationException("The raw class ''{0}'' of the parameterized type is not a class. Report it as a bug.", type);
            Class rt = (Class)rtr;
            TypeVariable<Class<T>>[] tvs = rt.getTypeParameters();
            if (tvs.length != ptps.length) {
                throw new TypeViolationException("The number of types ''{0}'' is not match with the number of type parameters of ''{1}'' Revise the specifications.", ptps.length, rt.getName());
            }
            int i = tvs.length;
            while (--i >= 0) {
                TypeVariable tv = tvs[i];
                GenericTypeRef o = (GenericTypeRef)map.get(tv);
                if (o == null) {
                    o = new SimpleGenericTypeRef(ptps[i]);
                    map.put(tv, o);
                } else {
                    o = new SimpleGenericTypeRef(null);
                    map.put(tv, o);
                }
                ExtractingTypeVarScope.garbageTypeVarsStage1(map, ptps[i], scope);
            }
            return;
        } else if (type instanceof TypeVariable) {
            GenericTypeRef ref = scope.resolveTypeVariable((TypeVariable)type);
            if (ref == null) return;
            ExtractingTypeVarScope.garbageTypeVarsStage1(map, ref.getType(), new BranchedTypeVarScope(ref.getScope(), scope));
            return;
        } else {
            if (type instanceof WildcardType || type instanceof GenericArrayType) return;
            throw new TypeViolationException("The type ''{0}'' is not supported. Report it as a bug.", type);
        }
    }

    @Override
    public GenericTypeRef resolveTypeVariable(TypeVariable<? extends GenericDeclaration> key) {
        GenericTypeRef ref = (GenericTypeRef)this.typeVarMap.get(key);
        if (ref == null || ref.getType() == null) {
            return null;
        }
        return ref;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        buf.append("{");
        first = true;
        for (TypeVariable key : this.typeVarMap.keySet()) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            Object gd = key.getGenericDeclaration();
            if (!(gd instanceof Class)) {
                if (gd instanceof Method) {
                    buf.append(((Method)gd).getName());
                    buf.append(':');
                } else {
                    buf.append(gd.toString());
                    buf.append(':');
                }
            }
            buf.append(key.getName());
            buf.append('=');
            GenericTypeRef tr = (GenericTypeRef)this.typeVarMap.get(key);
            if (tr != null) {
                buf.append(this.typeVarMap.get(key));
                continue;
            }
            buf.append('?');
        }
        buf.append('}');
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TypeVarMap
    extends HashMap<TypeVariable<? extends GenericDeclaration>, GenericTypeRef> {
        TypeVarMap() {
        }
    }
}

