package jp.sf.grizzly.storage.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import jp.sf.grizzly.storage.StreamStorage;
import jp.sf.grizzly.storage.StreamStorageException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ByteArrayStreamStorageImpl implements StreamStorage
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory
            .getLog(ByteArrayStreamStorageImpl.class);

    private int DEFAULT_ARRAY_SIZE = 512;

    private InputStream inputStream;

    private ByteArrayOutputStream outputStream;

    private String encoding;

    private byte[] buffer = null;

    public ByteArrayStreamStorageImpl(InputStream in, String encoding)
            throws StreamStorageException
    {
        init(in, encoding);
    }

    public void init(InputStream in, String encoding)
            throws StreamStorageException
    {
        //TODO better to wrap BufferredInputStream
        inputStream = in;
        this.encoding = encoding;
        outputStream = new ByteArrayOutputStream(DEFAULT_ARRAY_SIZE);
    }

    public void destroy()
    {
        buffer = null;
        outputStream = null;
    }

    /* (non-Javadoc)
     * @see jp.sf.grizzly.storage.impl.StreamStorage#commit()
     */
    public void commit() throws StreamStorageException
    {
        try
        {
            if (inputStream != null)
            {
                inputStream.close();
            }
            if (outputStream != null)
            {
                outputStream.flush();
                outputStream.close();
            }

            buffer = outputStream.toByteArray();
            inputStream = new ByteArrayInputStream(buffer);
            outputStream = new ByteArrayOutputStream(DEFAULT_ARRAY_SIZE);
        }

        catch (IOException e)
        {
            log.error("I/O error occurs. ", e);
            throw new StreamStorageException((Throwable) e);
        }
    }

    /* (non-Javadoc)
     * @see jp.sf.grizzly.storage.impl.StreamStorage#getResultInputStream()
     */
    public InputStream getResultInputStream() throws StreamStorageException
    {
        try
        {

            if (buffer == null)
            {
                if (inputStream.markSupported())
                {
                    inputStream.reset();
                }
                return inputStream;
            }

            return new ByteArrayInputStream(buffer);
        }

        catch (IOException e)
        {
            log.error("I/O error occurs. ", e);
            throw new StreamStorageException((Throwable) e);
        }
    }

    /* (non-Javadoc)
     * @see jp.sf.grizzly.storage.impl.StreamStorage#getEncoding()
     */
    public String getEncoding()
    {
        return encoding;
    }

    /**
     * @param encoding The encoding to set.
     */
    public void setEncoding(String encoding)
    {
        this.encoding = encoding;
    }

    /* (non-Javadoc)
     * @see jp.sf.grizzly.storage.impl.StreamStorage#getInputStream()
     */
    public InputStream getInputStream()
    {
        return inputStream;
    }

    /**
     * @param inputStream The inputStream to set.
     */
    public void setInputStream(InputStream inputStream)
    {
        this.inputStream = inputStream;
    }

    /* (non-Javadoc)
     * @see jp.sf.grizzly.storage.impl.StreamStorage#getOutputStream()
     */
    public OutputStream getOutputStream()
    {
        return outputStream;
    }

    /**
     * @param outputStream The outputStream to set.
     */
    public void setOutputStream(OutputStream outputStream)
    {
        if (outputStream instanceof ByteArrayOutputStream)
        {
            this.outputStream = (ByteArrayOutputStream) outputStream;
        }
        else
        {
            throw new IllegalArgumentException(
                    "The output stream is not ByteArrayOutputStream.");
        }
    }
}
