package jp.sf.grizzly.hatena.pipeline.valve;

import java.io.BufferedWriter;
import java.io.IOException;

/**
 * https://wwww.hatena.ne.jp/login 
 * is converted to
 * <p><a>https://www.haneta.ne.jp/login</a>https://www.haneta.ne.jp/login</p>
 * @author takeharu
 */
public class ConvertHttpsLinkValve extends AbstractHatenaValve
{
	String pattern = ".*https:.*";
	protected String getPattern()
	{
		return pattern;
	}

	protected void writeMatchLine(BufferedWriter writer, String line)
			throws IOException
	{
		String ln = line.trim();
		ln = ln.replaceAll("\\[|\\]","");
		
		int sp = ln.indexOf("https:");
		if(sp < 0)
		{
			return;
		}
		
		/* 
		 * Reserved Characters ";" | "/" | "?" | ":" | "@" | "&" | "=" | "+" | "$" | ","
		 * Unreserved Characters "-" | "_" | "." | "!" | "~" | "*" | "'" | "(" | ")"
		 * URI References "#"
		 */
		String[] strs = ln.split("\\[?https://[a-zA-Z0-9\\;\\/\\?\\:\\@\\&\\=\\+\\$\\,\\-\\_\\.\\!\\~\\*\\'\\(\\)\\#]*");
		
		String url = "";
		StringBuffer sb = new StringBuffer();
		sb.append("<p>");
		
		if(strs.length == 0)
		{	
			ln = "<a href=\"" + ln + "\">" + ln + "</a>";
			sb.append(ln);
		}
		else
		{			
			for(int i = 0; i < strs.length;i++)
			{
				int ep = 0;//終了点
				
				if(i+1 < strs.length) {
					ep = ln.indexOf(strs[i+1],sp);
				}else {
					ep = -1;
				}
				sb.append(strs[i]);
				if(ep >0) {					
					sb.append("<a href=\"");
					url = ln.substring(sp,ep);
					if(url.indexOf("https:")!=0) {
						url = url.substring(url.indexOf("https:"));
					}
					sb.append(url);
					sb.append("\">");
					sb.append(url);
					sb.append("</a>");
				}
				sp = ep;
			}
		}
		sb.append("</p>");
		writer.write(sb.toString());
		writer.newLine();
	}
}
