package jp.sf.grizzly.hatena.pipeline.valve;

import java.io.BufferedWriter;
import java.io.IOException;

public class ConvertMailtoLinkValve extends AbstractHatenaValve
{
	String pattern = "^.*?\\[?mailto:.*?";
	protected String getPattern()
	{
		return pattern;
	}

	protected void writeMatchLine(BufferedWriter writer, String line)
			throws IOException
	{		
		
		String[] strs = line.split("\\[?mailto:[a-z|A-Z|0-9|\\.|@]*");
		int i = line.indexOf("mailto:");
		String url = line.substring(i,line.indexOf(strs[1],i)); 
		if(strs.length==2 && strs[1].startsWith("]")) {
			strs[1] = strs[1].substring(1);
		}
		writer.write("<p>" + strs[0] + "<a href=\""
				+ url + "\">"+ url.substring("mailto:".length()) +"</a>"
					+strs[1]+"</p>");
		writer.newLine();
	}
}
