package jp.sf.grizzly.hatena.pipeline.valve;

import java.io.BufferedWriter;
import java.io.IOException;

import org.apache.commons.lang.StringEscapeUtils;

public class ConvertSuperPreValve extends AbstractHatenaValve
{

	private String pattern = "^\\>\\|\\||\\|\\|\\<"; //start with >|| or ||<

	private boolean tagStartFlg;

	protected String getPattern()
	{
		return pattern;
	}

	protected void writeMatchLine(BufferedWriter writer, String line)
			throws IOException
	{

		if(tagStartFlg && line.startsWith("||<"))
		{
			writer.write("</pre>");
			tagStartFlg = false;
		}
		else if(!tagStartFlg && line.startsWith(">||"))
		{
			writer.write("<pre>");
			tagStartFlg = true;
		}
		else
		{
			writer.write(line);
		}
		writer.newLine();
	}

	/**
	 * 不一致の行に対しては何も行いません。
	 * TODO 内部テキストのタグはエスケープする必要があるかも。
	 */
	protected void writeUnmatchLine(BufferedWriter writer, String line)
			throws IOException
	{
		if(tagStartFlg)
		{
			writer.write(StringEscapeUtils.escapeHtml(line));
			writer.newLine();
		}else {
			super.writeUnmatchLine(writer,line);
		}
	}

	protected void finish(BufferedWriter writer) throws IOException
	{
		if(tagStartFlg)
		{
			writer.write("</pre>");
			tagStartFlg = false;
		}
		else
		{
			super.finish(writer);
		}
	}
}
