package jp.sf.grizzly.hatena.pipeline.valve;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.sf.grizzly.pipeline.GrizzlyPipeline;
import jp.sf.grizzly.pipeline.PipelineException;
import jp.sf.grizzly.storage.StreamStorage;
import jp.sf.grizzly.storage.StreamStorageException;
import jp.sf.grizzly.storage.impl.FileStreamStorageImpl;
import junit.framework.TestCase;

public abstract class AbstractValveTest extends TestCase
{

	/**
	 * Logger for this class
	 */
	protected final Log log = LogFactory.getLog(this.getClass());

	GrizzlyPipeline pipeline = null;

	List valveList = new ArrayList();

	public AbstractValveTest()
	{
		super();
	}

	public AbstractValveTest(String arg0)
	{
		super(arg0);
	}

	protected String doLineInvoke(String str)
	{
		StringBuffer buffer = new StringBuffer();
		try
		{
			pipeline = new GrizzlyPipeline("", valveList);
			StreamStorage storage = new FileStreamStorageImpl(
					new ByteArrayInputStream(str.getBytes("UTF-8")), "UTF-8");
			pipeline.invoke(storage);
	
			BufferedReader r = null;
			try
			{
				r = new BufferedReader(new InputStreamReader(storage
						.getResultInputStream(), storage.getEncoding()));
				String l = null;
				while ((l = r.readLine()) != null)
				{
					buffer.append(l);
				}
			}
			catch (UnsupportedEncodingException e)
			{
				log.warn("Unsupported Encoding. ", e);
			}
			catch (StreamStorageException e)
			{
				log.warn("Stream Storage Exception. ", e);
			}
			catch (IOException e)
			{
				log.error("I/O Exception. ", e);
			}
			finally
			{
				if(r != null)
				{
					try
					{
						r.close();
					}
					catch (IOException e)
					{
					}
				}
			}
			storage.destroy();
		}
		catch (StreamStorageException e)
		{
			log.error("StreamStorage Exception.", e);
		}
		catch (PipelineException e)
		{
			log.error("Pipeline Exception.", e);
		}
		catch (Exception e)
		{
			log.error("Exception.", e);
		}
		return buffer.toString();
	}
	
}
