package jp.sf.grizzly.hatena.pipeline.valve;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

import jp.sf.grizzly.pipeline.GrizzlyPipeline;
import jp.sf.grizzly.pipeline.PipelineException;
import jp.sf.grizzly.storage.StreamStorage;
import jp.sf.grizzly.storage.StreamStorageException;
import jp.sf.grizzly.storage.impl.FileStreamStorageImpl;
import junit.framework.TestCase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConvertDefinitionListValveTest extends TestCase
{
	private static final String CONVERT_STRING = ":京都府:京都市\n:滋賀県:大津市\n:三重県:津市";
	private static final String CONVERT_RESULT = "<dl><dt>京都府</dt><dd>京都市</dd><dt>滋賀県</dt><dd>大津市</dd><dt>三重県</dt><dd>津市</dd></dl>";


	/**
	 * Logger for this class
	 */
	private static final Log log = LogFactory
			.getLog(ConvertDefinitionListValveTest.class);

	GrizzlyPipeline pipeline = null;
	List valveList = new ArrayList();

	public ConvertDefinitionListValveTest()
	{
		super();
	}

	public ConvertDefinitionListValveTest(String arg0)
	{
		super(arg0);
	}

	protected void setUp() throws Exception
	{
		valveList.add(new ConvertDefinitionListValve());
	}

	/**
	 * Rigourous Test :-)
	 */
	public void testInvoke()
	{
		StringBuffer buffer = new StringBuffer();
		try
		{
			pipeline = new GrizzlyPipeline("",valveList);
			StreamStorage storage = new FileStreamStorageImpl(
					new ByteArrayInputStream(CONVERT_STRING.getBytes("UTF-8")),
					"UTF-8");
			pipeline.invoke(storage);

			BufferedReader r = null;
			try
			{
				r = new BufferedReader(new InputStreamReader(storage
						.getResultInputStream(), storage.getEncoding()));
				String l = null;
				while ((l = r.readLine()) != null)
				{
					buffer.append(l);
				}
			}
			catch (UnsupportedEncodingException e)
			{
				log.warn("Unsupported Encoding. ", e);
			}
			catch (StreamStorageException e)
			{
				log.warn("Stream Storage Exception. ", e);
			}
			catch (IOException e)
			{
				log.error("I/O Exception. ", e);
			}
			finally
			{
				if(r != null)
				{
					try
					{
						r.close();
					}
					catch (IOException e)
					{
					}
				}
			}
			storage.destroy();
		}
		catch (StreamStorageException e)
		{
			log.error("StreamStorage Exception.", e);
		}
		catch (PipelineException e)
		{
			log.error("Pipeline Exception.", e);
		}
		catch (Exception e)
		{
			log.error("Exception.", e);
		}

		assertEquals(CONVERT_RESULT,buffer.toString());
//		assertEquals("<ul><span class=\"h5\">今日のできごと</span></p>",buffer.toString());
	}

}
