#! /usr/bin/ruby -I../lib

#==============================================================================#
# example/rect.rb
# $Id: rect.rb,v 1.1 2002/09/18 15:45:16 yuya Exp $
#==============================================================================#

require 'gruby/gruby'

#==============================================================================#

img = GRb.create(300, 200)

grid  = GRb::Color.new(208, 208, 208)
red   = GRb::Color::RED
green = GRb::Color::GREEN
blue  = GRb::Color::BLUE

0.step(300, 10) { |x| img.line(x, 0, x, 199, grid) }
0.step(200, 10) { |y| img.line(0, y, 299, y, grid) }

stroke = GRb::Stroke.new
stroke.color = red
stroke.width = 10
stroke.opacity = 50

fill = GRb::Fill.new
fill.color = blue
fill.opacity = 50

img.rect!( 10, 10 , 50, 40, :color => red, :width => 1)
img.rect!( 70, 10, 110, 40, :color => red, :width => 2)
img.rect!(130, 10, 170, 40, :color => red, :width => 3)
img.rect!(190, 10, 230, 40, :color => red, :width => 4)
img.rect!(250, 10, 290, 40, :color => red, :width => 5)

img.rect!( 10, 60,  50, 90, :color => red, :width => 5, :opacity => 100)
img.rect!( 70, 60, 110, 90, :color => red, :width => 5, :opacity =>  80)
img.rect!(130, 60, 170, 90, :color => red, :width => 5, :opacity =>  60)
img.rect!(190, 60, 230, 90, :color => red, :width => 5, :opacity =>  40)
img.rect!(250, 60, 290, 90, :color => red, :width => 5, :opacity =>  20)

img.rect!( 10, 110,  50, 140, nil, :color => blue, :opacity => 100)
img.rect!( 70, 110, 110, 140, nil, :color => blue, :opacity =>  80)
img.rect!(130, 110, 170, 140, nil, :color => blue, :opacity =>  60)
img.rect!(190, 110, 230, 140, nil, :color => blue, :opacity =>  40)
img.rect!(250, 110, 290, 140, nil, :color => blue, :opacity =>  20)

img.rect!( 10, 160,  50, 190, {:color => red, :width => 3, :pattern => [5, 5], :opacity => 100}, {:color => blue, :opacity => 100})
img.rect!( 70, 160, 110, 190, {:color => red, :width => 3, :pattern => [5, 5], :opacity =>  80}, {:color => blue, :opacity =>  80})
img.rect!(130, 160, 170, 190, {:color => red, :width => 3, :pattern => [5, 5], :opacity =>  60}, {:color => blue, :opacity =>  60})
img.rect!(190, 160, 230, 190, {:color => red, :width => 3, :pattern => [5, 5], :opacity =>  40}, {:color => blue, :opacity =>  40})
img.rect!(250, 160, 290, 190, {:color => red, :width => 3, :pattern => [5, 5], :opacity =>  20}, {:color => blue, :opacity =>  20})

img.png_file('rect.png')

#==============================================================================#
#==============================================================================#
