
#==============================================================================#
# gruby/color.rb
# $Id: color.rb,v 1.2 2002/09/18 15:43:59 yuya Exp $
#==============================================================================#

#==============================================================================#
# GRb Class
class GRb

  #============================================================================#
  # Color Class
  class Color

    #==========================================================================#

    def initialize(red, green, blue)
      @red   = red
      @green = green
      @blue  = blue
    end

    #==========================================================================#

    attr_reader :red, :green, :blue

    #==========================================================================#

    def self.parse(str)
      if /^#?([0-9a-fA-F]{6})$/ =~ str
        return self.new($1[0, 2].hex, $1[2, 2].hex, $1[4, 2].hex)
      else
        raise 'invalid color format'
      end
    end

    #==========================================================================#

    def r
      return @red
    end

    def g
      return @green
    end

    def b
      return @blue
    end

    def rgb
      return [@red, @green, @blue]
    end

    def invert
      return self.type.new(255 - @red, 255 - @green, 255 - @blue)
    end

    def set(image)
      return image.color_resolve(@red, @green, @blue)
    end

    #==========================================================================#

    RED   = self.new(255, 0, 0)
    GREEN = self.new(0, 255, 0)
    BLUE  = self.new(0, 0, 255)

  end # Color
  
end # GRb

#==============================================================================#
#==============================================================================#
