
#==============================================================================#
# $Id: bar.rb,v 1.2 2002/09/18 15:43:59 yuya Exp $
#==============================================================================#

module Graph

  module Chart

    class Bar < XYBase

      # Initialize Method

      def initialize(attribute)
        super(attribute)
      end

      # Private Instance Methods

      def create_chart(major_scale, items)
        return @value_set.collect { |value_set|
          chart = BarChart.new
          chart.scale  = major_scale
          chart.value  = (value_set.values + [nil] * items)[0, items]
          chart.color  = value_set.color
          chart.marker = value_set.marker
          chart
        }
      end

      # Instance Methods

      def draw(image, box)
        major_scale = create_major_scale(@attribute.scale1)
        minor_scale = create_minor_scale(@attribute.scale1)

        items = @value_set.collect { |value_set| value_set.values.size }.max

        graph_layer = create_layer(major_scale, minor_scale, items)
        scale_label = create_scale_label(major_scale)
        axis_label  = create_axis_label(items)

        layout = Layout.new(graph_layer, scale_label, axis_label)
        layout.draw(image, box)
      end

      # BarChart Class for test
      class BarChart < Graph::Chart::Line::LineChart
        def initialize
          @scale = nil
          @value = nil
          @color = nil
        end
        attr_accessor :scale, :value, :color
        def draw(image, box)
          color = @color.allocate(image)
          point = calculate(@value, @scale, box)
          origin = box.y + @scale.delta * @scale.raito(box.dy - 1)

          point.each { |x, y|
            if x && y
              image.filledRectangle(x - 5, y, x + 5, origin, color)
              image.rectangle(x - 5, y, x + 5, origin, image.colorResolve(64, 64, 64))
            end
          }
        end
      end # BarChart

    end # Bar















    # ١
    class BarBase < Base
    end

    # ١
    class VerticalBarBase < BarBase
    end

    # 
    class VerticalBar < VerticalBarBase
    end

    # Ѥ߾夲
    class VerticalStackedBar < VerticalBarBase
    end

    # 3D
    class Vertical3DBar < VerticalBarBase
    end

    # ١
    class HorizontalBarBase < BarBase
    end

    # 
    class HorizontalBar < HorizontalBarBase
    end

    # Ѥ߾夲
    class HorizontalStackedBar < HorizontalBarBase
    end

    # 3D
    class Horizontal3DBar < HorizontalBarBase
    end

  end # Chart

end # Graph
