
#==============================================================================#
# $Id: xybase.rb,v 1.2 2002/09/18 15:43:59 yuya Exp $
#==============================================================================#

module Graph

  module Chart

    class XYBase < Base

      # Initialize Method

      def initialize(attribute)
        super()
        @attribute = attribute
        @value_set = []
      end

      # Private Instance Methods

      def create_major_scale(attribute)
        scale = Scale.new
        scale.maximum  = attribute.maximum
        scale.minimum  = attribute.minimum
        scale.interval = attribute.interval.major
        return scale
      end
      private :create_major_scale

      def create_minor_scale(attribute)
        scale = Scale.new
        scale.maximum  = attribute.maximum
        scale.minimum  = attribute.minimum
        scale.interval = attribute.interval.minor
        return scale
      end
      private :create_minor_scale

      def create_scale_label(major_scale)
        if @attribute.scale1.label.visible
          scale_label = ScaleLabel.new
          scale_label.scale  = major_scale
          scale_label.font   = @attribute.scale1.label.font.create_font
          scale_label.format = @attribute.scale1.label.format
          return scale_label
        else
          return nil
        end
      end
      private :create_scale_label

      def create_axis_label(items)
        if @attribute.axis.label.visible
          axis_label = AxisLabel.new
          axis_label.number = items
          axis_label.label  = @attribute.axis.label.text
          axis_label.font   = @attribute.axis.label.font.create_font
          return axis_label
        else
          return nil
        end
      end
      private :create_axis_label

      def create_layer(major_scale, minor_scale, items)
        layer = Decorator::Layer.new

        layer << create_axis_grid_minor(items)
        layer << create_scale1_grid_minor(minor_scale)
        layer << create_axis_grid_major(items)
        layer << create_scale1_grid_major(major_scale)
        layer << create_scale1_origin(major_scale)

        layer << create_scale1_tics_minor(minor_scale)
        layer << create_scale1_tics_major(major_scale)
        layer << create_axis_tics_minor(items)
        layer << create_axis_tics_major(items)
        layer << create_baseline

        layer << create_chart(major_scale, items)

        return layer
      end
      private :create_layer

      def create_scale1_grid_major(major_scale)
        if @attribute.scale1.grid.major.visible
          part = ScaleGrid.new
          part.scale = major_scale
          part.color = @attribute.scale1.grid.major.color
          return part
        else
          return nil
        end
      end
      private :create_scale1_grid_major

      def create_scale1_grid_minor(minor_scale)
        if @attribute.scale1.grid.minor.visible
          part = ScaleGrid.new
          part.scale = minor_scale
          part.color = @attribute.scale1.grid.minor.color
          return part
        else
          return nil
        end
      end
      private :create_scale1_grid_minor

      def create_scale1_tics_major(major_scale)
        if @attribute.scale1.tics.major.visible
          part = ScaleTics.new
          part.scale   = major_scale
          part.size    = @attribute.scale1.tics.major.size
          part.color   = @attribute.scale1.tics.major.color
          part.inside  = @attribute.scale1.tics.major.inside
          part.outside = @attribute.scale1.tics.major.outside
          return part
        else
          return nil
        end
      end
      private :create_scale1_tics_major

      def create_scale1_tics_minor(minor_scale)
        if @attribute.scale1.tics.minor.visible
          part = ScaleTics.new
          part.scale   = minor_scale
          part.size    = @attribute.scale1.tics.minor.size
          part.color   = @attribute.scale1.tics.minor.color
          part.inside  = @attribute.scale1.tics.minor.inside
          part.outside = @attribute.scale1.tics.minor.outside
          return part
        else
          return nil
        end
      end
      private :create_scale1_tics_minor

      def create_scale1_origin(major_scale)
        if @attribute.scale1.origin.visible
          part = OriginLine.new
          part.scale = major_scale
          part.color = @attribute.scale1.origin.color
          return part
        else
          return nil
        end
      end
      private :create_scale1_origin

      def create_axis_grid_major(items)
        if @attribute.axis.grid.major.visible
          part = AxisMajorGrid.new
          part.color  = @attribute.axis.grid.major.color
          part.number = items
          return part
        else
          return nil
        end
      end
      private :create_axis_grid_major

      def create_axis_grid_minor(items)
        if @attribute.axis.grid.minor.visible
          part = AxisMinorGrid.new
          part.number = items
          part.color  = @attribute.axis.grid.minor.color
          return part
        else
          return nil
        end
      end
      private :create_axis_grid_minor

      def create_axis_tics_major(items)
        if @attribute.axis.tics.major.visible
          part = AxisMajorTics.new
          part.number  = items
          part.color   = @attribute.axis.tics.major.color
          part.size    = @attribute.axis.tics.major.size
          part.inside  = @attribute.axis.tics.major.inside
          part.outside = @attribute.axis.tics.major.outside
          return part
        else
          return nil
        end
      end
      private :create_axis_tics_major

      def create_axis_tics_minor(items)
        if @attribute.axis.tics.minor.visible
          part = AxisMinorTics.new
          part.number  = items
          part.color   = @attribute.axis.tics.minor.color
          part.size    = @attribute.axis.tics.minor.size
          part.inside  = @attribute.axis.tics.minor.inside
          part.outside = @attribute.axis.tics.minor.outside
          return part
        else
          return nil
        end
      end
      private :create_axis_tics_minor

      def create_baseline
        part = BaseLine.new
        part.color = Color.black
        return part
      end
      private :create_baseline

      def create_chart(major_scale, items)
        raise NotImplementedError, "don't use this class"
      end
      private :create_chart

      # Instance Methods

      def add_value(name, values, color, marker)
        @value_set << ValueSet.new(name, values, color, marker)
      end

      # ValueSet Class
      class ValueSet
        def initialize(name, values, color, marker)
          @name   = name
          @values = values
          @color  = color
          @marker = marker
        end
        attr_reader :name, :values, :color, :marker
      end # ValueSet

      # Scale Class
      class Scale
        def initialize
          @maximum  = nil
          @minimum  = nil
          @interval = nil
        end
        attr_accessor :maximum, :minimum, :interval
        def delta
          return @maximum - @minimum
        end
        def raito(box)
          return box.dy.to_f / self.delta.to_f
        end
        def origin(box)
          return box.y2
        end
        def raito(delta)
          return delta.to_f / self.delta.to_f
        end
      end # Scale

      # BaseLine Class for debug
      class BaseLine
        def initialize
          @color = nil
        end
        attr_accessor :color
        def draw(image, box)
          color = @color.allocate(image)
          image.rectangle(box.x, box.y, box.x2, box.y2, color)
        end
      end # BaseLine

      # OriginLine Class
      class OriginLine
        def initialize
          @scale = nil
          @color = nil
        end
        attr_accessor :scale, :color
        def draw(image, box)
          if @scale.minimum <= 0 && @scale.maximum >= 0
            y = box.y + @scale.maximum * @scale.raito(box.dy - 1)
            image.line(box.x, y, box.x2, y, @color.allocate(image))
          end
        end
      end # OriginLine

      # ScaleTics Class
      class ScaleTics
        def initialize
          @scale     = nil
          @size      = nil
          @color     = nil
          @inside    = nil
          @outside   = nil
        end
        attr_accessor :scale, :size, :color, :inside, :outside
        def draw(image, box)
          color    = @color.allocate(image)
          interval = @scale.interval
          raito    = @scale.raito(box.dy - 1)
          origin   = @scale.delta + @scale.minimum

          if @scale.maximum > 0
            base   = [@scale.minimum, 0].max
            delta  = @scale.maximum - base
            number = (delta.to_f / interval.to_f).floor + 1
            number.times { |i|
              y = box.y + (origin - base - interval * i) * raito
              draw_tics(image, box, y, color)
            }
          end

          if @scale.minimum < 0
            base   = [@scale.maximum, 0].min
            delta  = (@scale.minimum - base).abs
            number = (delta.to_f / interval.to_f).floor + 1
            number.times { |i|
              y = box.y + (origin - base + interval * i) * raito
              draw_tics(image, box, y, color)
            }
          end

          image.line(box.x, box.y, box.x, box.y2, color)
        end
        def draw_tics(image, box, y, color)
          image.line(box.x, y, box.x + @size, y, color) if @inside
          image.line(box.x, y, box.x - @size, y, color) if @outside
        end
      end # ScaleTics

      # ScaleGrid Class
      class ScaleGrid
        def initialize
          @scale = nil
          @color = nil
        end
        attr_accessor :scale, :color
        def draw(image, box)
          color    = @color.allocate(image)
          interval = @scale.interval
          raito    = @scale.raito(box.dy - 1)
          origin   = @scale.delta + @scale.minimum

          if @scale.maximum > 0
            base   = [@scale.minimum, 0].max
            delta  = @scale.maximum - base
            number = (delta.to_f / interval.to_f).floor + 1
            number.times { |i|
              y = box.y + (origin - base - interval * i) * raito
              image.line(box.x, y, box.x2, y, color)
            }
          end

          if @scale.minimum < 0
            base   = [@scale.maximum, 0].min
            delta  = (@scale.minimum - base).abs
            number = (delta.to_f / interval.to_f).floor + 1
            number.times { |i|
              y = box.y + (origin - base + interval * i) * raito
              image.line(box.x, y, box.x2, y, color)
            }
          end
        end
      end # ScaleGrid

      # ScaleLabel Class
      class ScaleLabel
        def initialize
          @scale  = nil
          @font   = nil
          @format = nil
        end
        attr_accessor :scale, :font, :format
        def draw(image, box)
          interval = @scale.interval
          delta    = @scale.delta
          raito    = @scale.raito(box.dy - 1)
          origin   = @scale.delta + @scale.minimum
          width    = self.dx

          if @scale.maximum > 0
            base   = [@scale.minimum, 0].max
            delta  = @scale.maximum - base
            number = (delta.to_f / interval.to_f).floor + 1

            (0...number).collect { |i|
              value = i * interval + base

              x = box.x + width
              y = box.y + (origin - value) * raito

              text = Graph::Text.new(@font, @format.call(value), Graph::Text::ALIGN_RIGHT, Graph::Text::VALIGN_MIDDLE)
              text.draw2(image, x, y)
            }
          end

          if @scale.minimum < 0
            base   = [@scale.maximum, 0].min
            delta  = (@scale.minimum - base).abs
            number = (delta.to_f / interval.to_f).floor

            (0..number).collect { |i|
              value = i * -interval + base

              x = box.x + width
              y = box.y + (origin - value) * raito

              text = Graph::Text.new(@font, @format.call(value), Graph::Text::ALIGN_RIGHT, Graph::Text::VALIGN_MIDDLE)
              text.draw2(image, x, y)
            }
          end
        end
        def dx
          texts = []

          if @scale.maximum > 0
            base   = [@scale.minimum, 0].max
            delta  = @scale.maximum - base
            number = (delta.to_f / @scale.interval.to_f).floor + 1

            (0...number).collect { |i|
              value = i * @scale.interval + base
              text  = @format.call(value)
              texts << Graph::Text.new(@font, text, Graph::Text::ALIGN_RIGHT, Graph::Text::VALIGN_MIDDLE)
            }
          end

          if @scale.minimum < 0
            base   = [@scale.maximum, 0].min
            delta  = (@scale.minimum - base).abs
            number = (delta.to_f / @scale.interval.to_f).floor

            (0..number).collect { |i|
              value = i * -@scale.interval + base
              text = @format.call(value)
              texts << Graph::Text.new(@font, text, Graph::Text::ALIGN_RIGHT, Graph::Text::VALIGN_MIDDLE)
            }
          end

          return texts.collect { |text| text.dx }.max
        end
      end # ScaleLabel

      # AxisMajorGrid Class
      class AxisMajorGrid
        def initialze
          @number = nil
          @color  = nil
        end
        attr_accessor :number, :color
        def draw(image, box)
          color  = @color.allocate(image)
          width  = (box.dx - 1).to_f / @number.to_f
          number = @number + 1

          number.times { |i|
            x = (box.x + width * i).ceil
            image.line(x, box.y, x, box.y2, color)
          }
        end
      end # AxisMajorGrid

      # AxisMinorGrid Class
      class AxisMinorGrid
        def initialize
          @number = nil
          @color = nil
        end
        attr_accessor :number, :color
        def draw(image, box)
          color = @color.allocate(image)
          width = (box.dx - 1).to_f / @number.to_f
          start = box.x + width / 2.0

          number.times { |i|
            x = (start + width * i).ceil
            image.line(x, box.y, x, box.y2, color)
          }
        end
      end # AxisMinorGrid

      # AxisMajorTics Class
      class AxisMajorTics
        def initialzie
          @number  = nil
          @color   = nil
          @size    = nil
          @inside  = nil
          @outside = nil
        end
        attr_accessor :number, :color, :size, :inside, :outside
        def draw(image, box)
          color  = @color.allocate(image)
          width  = (box.dx - 1).to_f / @number.to_f
          start  = box.x
          number = @number + 1

          number.times { |i|
            x = (start + width * i).ceil
            image.line(x, box.y2, x, box.y2 - @size, color) if @inside
            image.line(x, box.y2, x, box.y2 + @size, color) if @outside
          }

          image.line(box.x, box.y2, box.x2, box.y2, color)
        end
      end # AxisMajorTics

      # AxisMinorTics Class
      class AxisMinorTics
        def initialize
          @number  = nil
          @color   = nil
          @size    = nil
          @inside  = nil
          @outside = nil
        end
        attr_accessor :number, :color, :size, :inside, :outside
        def draw(image, box)
          color  = @color.allocate(image)
          width  = (box.dx - 1).to_f / @number.to_f
          start  = box.x + width / 2.0

          @number.times { |i|
            x = (start + width * i).ceil
            image.line(x, box.y2, x, box.y2 - @size, color) if @inside
            image.line(x, box.y2, x, box.y2 + @size, color) if @outside
          }

          image.line(box.x, box.y2, box.x2, box.y2, color)
        end
      end # AxisMinorTics

      # AxisLabel Class
      class AxisLabel
        def initialize
          @number = nil
          @label  = nil
          @font   = nil
        end
        attr_accessor :number, :label, :font
        def draw(image, box)
          width = box.dx.to_f / @number.to_f
          start = box.x + width / 2.0
          texts = create_texts

          @number.times { |i|
            x = (start + width * i).ceil
            y = box.y

            texts[i].draw2(image, x, y)
          }
        end
        def create_texts
          return (0...@number).collect { |i|
            Graph::Text.new(@font, @label[i].to_s, Graph::Text::ALIGN_CENTER, Graph::Text::VALIGN_TOP)
          }
        end
        def dy
          return create_texts.collect { |text| text.dy }.max
        end
      end # AxisLabel

      # Layout Class
      class Layout
        def initialize(graph, scale, axis)
          @graph = graph
          @scale = scale
          @axis  = axis
        end
        def draw(image, box)
          case [!@scale.nil?, !@axis.nil?]
          when [true, true]
            scale_dx = @scale.dx
            axis_dy  = @axis.dy

            graph_box = Graph::Box.new
            graph_box.x  = box.x + scale_dx
            graph_box.y  = box.y
            graph_box.dx = box.dx - scale_dx
            graph_box.dy = box.dy - axis_dy

            scale_box = Graph::Box.new
            scale_box.x  = box.x
            scale_box.y  = box.y
            scale_box.dx = scale_dx
            scale_box.dy = box.dy - axis_dy

            axis_box = Graph::Box.new
            axis_box.x  = box.x + scale_dx
            axis_box.y  = box.y + box.dy - axis_dy
            axis_box.dx = box.dx - scale_dx
            axis_box.dy = axis_dy

            @graph.draw(image, graph_box)
            @scale.draw(image, scale_box)
            @axis.draw(image, axis_box)
          when [true, false]
            scale_dx = @scale.dx

            graph_box = Box.new
            graph_box.x  = box.x + scale_dx
            graph_box.y  = box.y
            graph_box.dx = box.dx - scale_dx
            graph_box.dy = box.dy

            scale_box = Box.new
            scale_box.x  = box.x
            scale_box.y  = box.y
            scale_box.dx = scale_dx
            scale_box.dy = box.dy

            @graph.draw(image, graph_box)
            @scale.draw(image, scale_box)
          when [false, true]
            axis_dy = @axis.dy

            graph_box = Box.new
            graph_box.x  = box.x
            graph_box.y  = box.y
            graph_box.dx = box.dx
            graph_box.dy = box.dy - axis_dy

            axis_box = Box.new
            axis_box.x  = box.x
            axis_box.y  = box.y + box.dy - axis_dy
            axis_box.dx = box.dx
            axis_box.dy = axis_dy

            @graph.draw(image, graph_box)
            @axis.draw(image, axis_box)
          when [false, false]
            @graph.draw(image, box)
          else
            raise 'bug?'
          end
        end
      end # Layout

    end # XYGraphBase

  end # Chart

end # Graph
