
#==============================================================================#
# gruby/graph/decorator/split.rb
# $Id: split.rb,v 1.4 2002/09/19 10:58:13 yuya Exp $
#==============================================================================#

class GRb

  module Graph

    module Decorator

      class VerticalSplitBase < Base

        def initialize(upper, lower)
          @upper = upper
          @lower = lower
        end

        def has_child?
          return @upper || @lower
        end

        def draw_self(image, box)
          # nop
        end

        def draw_child(image, box)
          height = calculate_height
          @upper.draw(image, calculate_upper(box, height))
          @lower.draw(image, calculate_lower(box, height))
        end

        def dx
          raise NotImplementedError
        end

        def dy
          raise NotImplementedError
        end

      end

      #====================================================================#

      class VerticalSplitUpper < VerticalSplitBase

        def calculate_height
          return @upper.dy
        end

        def calculate_upper(box, height)
          upper_box = Box.new
          upper_box.x  = box.x
          upper_box.y  = box.y
          upper_box.dx = box.dx
          upper_box.dy = height
          return upper_box
        end

        def calculate_lower(box, height)
          lower_box = Box.new
          lower_box.x  = box.x
          lower_box.y  = box.y + height
          lower_box.dx = box.dx
          lower_box.dy = box.dy - height
          return lower_box
        end

      end

      #====================================================================#

      class VerticalSplitLower < VerticalSplitBase

        def calculate_height
          return @lower.dy
        end

        def calculate_upper(box, height)
          upper_box = Box.new
          upper_box.x  = box.x
          upper_box.y  = box.y
          upper_box.dx = box.dx
          upper_box.dy = box.dy - height
          return upper_box
        end

        def calculate_lower(box, height)
          lower_box = Box.new
          lower_box.x  = box.x
          lower_box.y  = box.y2 - height + 1
          lower_box.dx = box.dx
          lower_box.dy = height
          return lower_box
        end

      end

      #====================================================================#

      class HorizontalSplitBase < Base

        def initialize(left, right)
          @left  = left
          @right = right
        end

        def has_child?
          return @left || @right
        end

        def draw_self(image, box)
          # nop
        end

        def draw_child(image, box)
          width = calculate_width
          @left.draw(image, calculate_left(box, width))
          @right.draw(image, calculate_right(box, width))
        end

        def dx
          raise NotImplementedError
        end

        def dy
          raise NotImplementedError
        end

      end

      #====================================================================#

      class HorizontalSplitLeft < HorizontalSplitBase

        def calculate_width
          return @left.dx
        end

        def calculate_left(box, width)
          left_box = Box.new
          left_box.x  = box.x
          left_box.y  = box.y
          left_box.dx = width
          left_box.dy = box.dy
          return left_box
        end

        def calculate_right(box, width)
          right_box = Box.new
          right_box.x  = box.x + width
          right_box.y  = box.y
          right_box.dx = box.dx - width
          right_box.dy = box.dy
          return right_box
        end

      end

      #====================================================================#

      class HorizontalSplitRight < HorizontalSplitBase

        def calculate_width
          return @right.dx
        end

        def calculate_left(box, width)
          left_box = Box.new
          left_box.x  = box.x
          left_box.y  = box.y
          left_box.dx = box.dx - width
          left_box.dy = box.dy
          return left_box
        end

        def calculate_right(box, width)
          right_box = Box.new
          right_box.x  = box.x2 - width + 1
          right_box.y  = box.y
          right_box.dx = width
          right_box.dy = box.dy
          return right_box
        end

      end

    end

  end

end # GRb

#==============================================================================#
#==============================================================================#
