
#==============================================================================#
# gruby/graph/graph/line.rb
# $Id: line.rb,v 1.4 2002/09/19 11:02:43 yuya Exp $
#==============================================================================#

class GRb

  module Graph

    class LineBase < GraphBase

      def create_legend
        font = @legend.font.create_font

        legend = Legend.new(@legend)

        @data.each { |item|
          if item[:marker]
            legend.add(font, item[:name], Legend::Marker::LineMarker.new(item[:color], item[:marker]))
          else
            legend.add(font, item[:name], Legend::Marker::Line.new(item[:color]))
          end
        }

        return legend
      end
      private :create_legend

      def create_graph
        graph = create_chart

        @data.each { |item|
          graph.add_value(item[:name], item[:value], item[:color], item[:marker])
        }

        return graph
      end
      private :create_graph

    end

    class Line < LineBase

      def create_attribute_chart
        return Attribute::Chart::Line.new
      end
      private :create_attribute_chart

      def create_chart
        return Chart::Line.new(@chart)
      end
      private :create_chart

    end

  end

end # GRb

#==============================================================================#
#==============================================================================#
