
#==============================================================================#
# $Id: padding.rb,v 1.3 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/property/padding.rb,v $
#==============================================================================#

require 'grb/chart/base/property/base'
require 'grb/chart/base/decorator/padding'

#==============================================================================#

module GRb

  module Chart

    class PaddingProperty < PropertyBase

      def initialize
        @left   = nil
        @right  = nil
        @top    = nil
        @bottom = nil
      end

      attr_accessor :left, :right, :top, :bottom

      def create_decorator(child)
        decorator = PaddingDecorator.new(child)
        decorator.spacing_left   = @left   || 0
        decorator.spacing_right  = @right  || 0
        decorator.spacing_top    = @top    || 0
        decorator.spacing_bottom = @bottom || 0

        return decorator
      end

    end # PaddingProperty

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
