
#==============================================================================#
# $Id: picture.rb,v 1.3 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/property/picture.rb,v $
#==============================================================================#

require 'grb/chart/base/property/base'
require 'grb/chart/base/decorator/picture'

#==============================================================================#

module GRb

  module Chart

    class PictureProperty < PropertyBase

      def initialize
        @visible  = nil
        @filepath = nil
        @opacity  = nil
      end

      attr_accessor :visible, :filepath, :opacity

      def create_decorator(child)
        if @visible && @filepath
          decorator = PictureDecorator.new(child)
          decorator.filepath = @filepath
          decorator.opacity  = @opacity || 100
          return decorator
        else
          return child
        end
      end

    end # PictureProperty

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
