
#==============================================================================#
# $Id: orign_line.rb,v 1.2 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/xy_base/decorator/orign_line.rb,v $
#==============================================================================#

require 'grb/chart/base/decorator/no_child_base'

#==============================================================================#

module GRb

  module Chart

    class OriginLineDecorator < NoChildDecoratorBase

      def initialize
        @scale = nil
        @color = nil
      end

      attr_accessor :scale, :color

      def draw(image, box)
        if @scale.minimum <= 0 && @scale.maximum >= 0
          y = box.y + @scale.maximum * @scale.raito(box.dy - 1)
          image.line(box.x, y, box.x2, y, @color)
        end
      end

    end # OriginLineDecorator

  end # Chart

end # GRb

#==============================================================================#

if $0 == __FILE__
  require 'grb/image'
  require 'grb/chart/scale'

  GRb::Image.create_and_write_png_file(200, 200, false, __FILE__.sub(/\.rb/, '.png')) { |image|
    GRb::Chart::Decorator::OriginLine.new.instance_eval {
      self.scale = GRb::Chart::Scale.new(100, -20, 10)
      self.color = GRb::Color.red(128)
      self.draw(image, GRb::Chart::Box.new(10, 10, 180, 180))
    }
  }
end

#==============================================================================#
#==============================================================================#
