
#==============================================================================#
# $Id: view.rb,v 1.5 2004/01/16 14:37:33 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/view.rb,v $
#==============================================================================#

require 'delegate'
require 'grb/image'
require 'grb/polygon'

#==============================================================================#

module GRb

  class Image

    def view(x, y, dx, dy, sx, sy, sdx, sdy)
      return GRb::View.new(self, x, y, dx, dy, sx, sy, sdx, sdy)
    end

  end # Image

  class View < DelegateClass(Image)

    def initialize(image, x, y, dx, dy, sx, sy, sdx, sdy)
      @image     = image
      @x, @y     = x, y
      @dx, @dy   = dx, dy
      @sx, @sy   = sx, sy
      @sdx, @sdy = sdx, sdy

      super(@image)
    end

    def tr_x(x)
      return (@x + (@sx + x) * (@dx.to_f / @sdx.to_f)).floor
    end
    protected :tr_x

    def tr_y(y)
      return (@y + (@sy + y) * (@dy.to_f / @sdy.to_f)).floor
    end
    protected :tr_y

    def tr_dx(dx)
      return (dx * (@dx.to_f / @sdx.to_f)).floor
    end
    protected :tr_dx

    def tr_dy(dy)
      return (dy * (@dy.to_f / @sdy.to_f)).floor
    end
    protected :tr_dy

    # NOT TESTED:
    def copy(image, x, y, sx, sy, dx, dy)
      @image.copy(image, tr_x(x), tr_y(y), tr_x(sx), tr_y(sy), tr_dx(dx), tr_dy(dy))
    end

    # NOT TESTED:
    def copy_merge(image, x, y, sx, sy, dx, dy, percent)
      @image.copy_merge(image, tr_x(x), tr_y(y), tr_x(sx), tr_y(sy), tr_dx(dx), tr_dy(dy), percent)
    end

    # NOT TESTED:
    def copy_merge_gray(image, x, y, sx, sy, dx, dy, percent)
      @image.copy_merge_gray(image, tr_x(x), tr_y(y), tr_x(sx), tr_y(sy), tr_dx(dx), tr_dy(dy), percent)
    end

    # NOT TESTED:
    def copy_resampled(image, x, y, sx, sy, dx, dy, sdx, sdy)
      @image.copy_resampled(image, tr_x(x), tr_y(y), tr_x(sx), tr_y(sy), tr_dx(dx), tr_dy(dy), tr_dx(sdx), tr_dy(sdy))
    end

    # NOT TESTED:
    def copy_resized(image, x, y, sx, sy, dx, dy, sdx, sdy)
      @image.copy_resized(image, tr_x(x), tr_y(y), tr_x(sx), tr_y(sy), tr_dx(dx), tr_dy(dy), tr_dx(sdx), tr_dy(sdy))
    end

    # NOT TESTED:
    def get_pixel(x, y)
      return @image.get_pixel(tr_x(x), tr_(y))
    end

    # NOT TESTED:
    def set_pixel(x, y, color)
      return @image.set_pixel(tr_x(x), tr_(y), color)
    end

    def pset(x, y, color)
      @image.pset(tr_x(x), tr_y(y), color)
    end

    def rect(x1, y1, x2, y2, line = nil, fill = nil)
      @image.rect(tr_x(x1), tr_y(y1), tr_x(x2), tr_y(y2), line, fill)
    end

    def line(x1, y1, x2, y2, line)
      @image.line(tr_x(x1), tr_y(y1), tr_x(x2), tr_y(y2), line)
    end

    def circle(cx, cy, rx, ry, line = nil, fill = nil)
      @image.circle(tr_x(cx), tr_y(cy), tr_dx(rx), tr_dy(ry), line, fill)
    end

    def arc(cx, cy, rx, ry, deg1, deg2, line = nil, fill = nil)
      @image.arc(tr_x(cx), tr_y(cy), tr_dx(rx), tr_dy(ry), deg1, deg2, line, fill)
    end

    def polygon(poly, line = nil, fill = nil)
      fixed_poly = GRb::Polygon.new
      poly.each { |x, y| fixed_poly.add(tr_x(x), tr_y(y)) }

      @image.polygon(fixed_poly, line, fill)
    end

    def string(font, x, y, angle, color, text)
      @image.string(font, tr_x(x), tr_y(y), angle, color, text)
    end

    def fill(x, y, fill, border = nil)
      @image.fill(tr_x(x), tr_y(y), fill, border)
    end

    def gradation(x1, y1, x2, y2, start_color, end_color, angle = 0, opacity = 100)
      @image.gradation(tr_x(x1), tr_y(y1), tr_x(x2), tr_y(y2), start_color, end_color, angle, opacity)
    end

  end # View

end # GRb

#==============================================================================#

if $0 == __FILE__
  x, y, dx, dy = 100, 100, 200, 100
  sx, sy, sdx, sdy = 50, 25, 100, 50

  image = GRb::Image.create(400, 300)
  image.rect(x, y, x + dx, y + dy, GRb::Color.red)

  view = image.view(x, y, dx, dy, sx, sy, sdx, sdy)
  view.line(-5, 0, 5, 0, GRb::Color.red(128))
  view.line(0, -5, 0, 5, GRb::Color.red(128))

  image.write_png_file(__FILE__ + '.png')
end

#==============================================================================#
#==============================================================================#
