/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class RiderSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox series;
    private JComboBox numbers;
    private StatusBrowserModel model;

    RiderSelectionPanel(String str, final StatusBrowserModel model, final KamenrideSelectionPanel kamenride) {
        this.model = model;
        ArrayList<String> seriesList = this.model.getSeriesList();
        JLabel label = new JLabel(str);
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        this.series = new JComboBox<Object>(seriesList.toArray());
        this.series.setMaximumSize(new Dimension(100, Short.MAX_VALUE));
        this.numbers = new JComboBox();
        this.numbers.setMaximumSize(new Dimension(100, Short.MAX_VALUE));
        final JLabel name = new JLabel();
        this.setLayout(new BoxLayout(this, 0));
        this.add(label);
        this.add(this.series);
        this.add(new JLabel("\uff0d"));
        this.add(this.numbers);
        this.add(Box.createRigidArea(new Dimension(10, 10)));
        this.add(name);
        this.series.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedSeries = (String)RiderSelectionPanel.this.series.getSelectedItem();
                ArrayList<String> nums = model.getNumberList(selectedSeries);
                RiderSelectionPanel.this.numbers.removeAllItems();
                Iterator i = nums.iterator();
                while (i.hasNext()) {
                    RiderSelectionPanel.this.numbers.addItem(i.next());
                }
            }
        });
        this.numbers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                name.setText("");
                Rider r = RiderSelectionPanel.this.getSelectedRider();
                if (r != null) {
                    name.setText(r.getName());
                    if (kamenride != null) {
                        kamenride.setCheckBoxEnabled(r.isKamenridable());
                    }
                }
            }
        });
    }

    public Rider getSelectedRider() {
        Rider rider = null;
        String s = (String)this.series.getSelectedItem();
        String n = (String)this.numbers.getSelectedItem();
        if (s != null && n != null) {
            rider = this.model.search(s, Integer.parseInt(n));
        }
        return rider;
    }
}

