/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import jp.sourceforge.gtibuilder.util.ErrorDialog;
import jp.sourceforge.gtibuilder.util.StringArray;

public class UserPreferences {
    private static final String dataMap = UserPreferences.getPreferenceDirectory() + File.separator + "GTI_Builder_Info.txt";
    private static UserPreferences system = null;
    private StringArray array;
    private boolean inited = false;
    private File file = null;

    private UserPreferences(File file) {
        this.file = file;
        this.init(file);
    }

    private void init(File file) {
        if (!this.inited) {
            try {
                this.array = file.exists() ? new StringArray(new FileInputStream(file)) : new StringArray();
                this.inited = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                ErrorDialog.showError(fileNotFoundException);
            }
        }
    }

    public void clear() {
        if (this.inited) {
            this.array = null;
            this.inited = false;
        }
    }

    public static void clearSystem() {
        system = null;
    }

    public String getData(String string) {
        return (String)this.array.getContent(string);
    }

    public boolean setData(String string, String string2) {
        if (!this.array.add(string, string2)) {
            return this.array.change(string, string2);
        }
        return true;
    }

    public void saveData() {
        byte[] byArray = this.array.getData();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            ErrorDialog.showError(iOException);
        }
    }

    public void setStringArray(StringArray stringArray) {
        if (!this.file.getAbsolutePath().equals(dataMap)) {
            this.array = stringArray;
        }
    }

    public StringArray getStringArray() {
        if (!this.file.getAbsolutePath().equals(dataMap)) {
            return this.array;
        }
        return null;
    }

    public static UserPreferences getSystemPreferences() {
        if (system == null) {
            File file = UserPreferences.getPreferenceDirectory();
            if (!file.exists()) {
                file.mkdirs();
            }
            system = new UserPreferences(new File(dataMap));
        }
        return system;
    }

    public static UserPreferences loadPreferences(String string) {
        return new UserPreferences(new File(UserPreferences.getPreferenceDirectory() + File.separator + string + ".txt"));
    }

    public static File getPreferenceDirectory() {
        return new File(System.getProperty("user.home") + File.separator + ".gtibuilder" + File.separator + "0.2");
    }
}

