/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import jp.sourceforge.gtibuilder.editor.Editor;
import jp.sourceforge.gtibuilder.editor.EditorComponent;
import jp.sourceforge.gtibuilder.io.FileDataBase;
import jp.sourceforge.gtibuilder.io.FileType;
import jp.sourceforge.gtibuilder.main.DefaultNewPanel;
import jp.sourceforge.gtibuilder.main.MainWindow;
import jp.sourceforge.gtibuilder.main.NewPanel;
import jp.sourceforge.gtibuilder.project.Project;
import jp.sourceforge.gtibuilder.project.ProjectManager;
import jp.sourceforge.gtibuilder.project.ProjectNewPanel;
import jp.sourceforge.gtibuilder.util.ErrorDialog;
import jp.sourceforge.gtibuilder.util.StringArray;

public class NewDialog
extends JDialog
implements ActionListener,
TreeSelectionListener {
    JTree jt = new JTree();
    JScrollPane jsp = new JScrollPane(this.jt);
    DefaultMutableTreeNode root = new DefaultMutableTreeNode("New File...");
    DefaultMutableTreeNode project = new DefaultMutableTreeNode("New Project");
    NodeAndFile[] nodes = null;
    JButton next = new JButton();
    JButton back = new JButton();
    JButton cancel = new JButton();
    JPanel mother = new JPanel();
    ProjectManager pm = null;
    Hashtable map = new Hashtable();
    int step = 0;
    int sproject = 0;
    JComponent startup = null;
    NewPanel newPanel = null;
    EditorComponent comp = null;

    public NewDialog(ProjectManager projectManager) {
        super((Frame)MainWindow.getMainWindow(), true);
        this.pm = projectManager;
        this.init();
        Toolkit toolkit = this.getToolkit();
        ((Component)this).setLocation((toolkit.getScreenSize().width - this.getSize().width) / 2, (toolkit.getScreenSize().height - this.getSize().height) / 2);
    }

    protected void init() {
        Object object;
        ResourceBundle resourceBundle = null;
        ResourceBundle resourceBundle2 = null;
        try {
            resourceBundle = ResourceBundle.getBundle("jp.sourceforge.gtibuilder.main.Bundle");
            resourceBundle2 = ResourceBundle.getBundle("jp.sourceforge.gtibuilder.io.FileStrings");
        }
        catch (MissingResourceException missingResourceException) {
            ErrorDialog.showError(missingResourceException);
            return;
        }
        this.setTitle(resourceBundle.getString("New.title"));
        this.root.setUserObject(resourceBundle.getString("New.root"));
        this.project.setUserObject(resourceBundle.getString("New.project"));
        this.next.setText(resourceBundle.getString("New.next"));
        this.back.setText(resourceBundle.getString("New.back"));
        this.cancel.setText(resourceBundle.getString("All.cancel"));
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewDialog.this.hide();
                NewDialog.this.dispose();
            }
        });
        this.back.addActionListener(this);
        this.back.setEnabled(false);
        this.next.setEnabled(false);
        this.next.addActionListener(this);
        ((Component)this).setSize(300, 200);
        this.root.add(this.project);
        if (this.pm.getProject() != null) {
            object = FileDataBase.getAllCanNewTypes();
            int n = ((FileType[])object).length;
            this.nodes = new NodeAndFile[n];
            for (int i = 0; n > i; ++i) {
                this.nodes[i] = new NodeAndFile(new DefaultMutableTreeNode(object[i].getNewComment()), object[i]);
                this.root.add(this.nodes[i].getTreeNode());
            }
        }
        object = new DefaultTreeModel(this.root);
        this.jt.setModel((TreeModel)object);
        this.getContentPane().setLayout(new BorderLayout());
        this.startup = this.jsp;
        this.getContentPane().add((Component)this.jsp, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.next);
        jPanel.add(this.back);
        jPanel.add(this.cancel);
        this.next.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.next);
        this.getContentPane().add((Component)jPanel, "South");
        this.jt.addTreeSelectionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.next) {
            if (this.step == 0) {
                this.showConfig();
            } else if (this.step == 1 && this.newPanel.next()) {
                this.dispose();
                if (this.sproject == 1) {
                    StringArray stringArray = this.newPanel.getProperties();
                    stringArray.add("WINDOW_MANAGER", this.pm);
                    this.pm.add(new Project(stringArray));
                } else {
                    Project project = this.pm.getProject();
                    StringArray stringArray = this.newPanel.getProperties();
                    stringArray.add("PROJECT", project);
                    this.comp.init(stringArray, this.newPanel.getFileType());
                    Editor editor = new Editor(this.comp, project);
                    project.addEditor(editor);
                }
            }
        } else if (actionEvent.getSource() == this.back && this.step == 1 && this.newPanel.back()) {
            this.getContentPane().remove(this.newPanel);
            this.newPanel = null;
            this.getContentPane().add((Component)this.jsp, "Center");
            this.back.setEnabled(false);
            this.getContentPane().repaint();
            this.step = 0;
            this.sproject = 1;
        }
    }

    protected void showConfig() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.jt.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        if (defaultMutableTreeNode == this.project) {
            this.showNewProject();
            return;
        }
        int n = this.nodes.length;
        for (int i = 0; i < n; ++i) {
            if (!this.nodes[i].checkTreeNode(defaultMutableTreeNode)) continue;
            FileType fileType = this.nodes[i].getFileType();
            try {
                this.comp = (EditorComponent)fileType.getInstance();
                this.newPanel = this.comp.getNewFilePropertyPane();
                if (this.newPanel == null) {
                    this.newPanel = new DefaultNewPanel();
                }
                this.newPanel.setFileType(fileType);
                this.getContentPane().remove(this.jsp);
                this.getContentPane().add((Component)this.newPanel, "Center");
                this.back.setEnabled(true);
                this.newPanel.showed();
                ((JPanel)this.getContentPane()).revalidate();
                this.step = 1;
                this.sproject = 0;
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorDialog.showError(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                ErrorDialog.showError(instantiationException);
            }
            catch (SecurityException securityException) {
                ErrorDialog.showError(securityException);
            }
            break;
        }
    }

    protected void showNewProject() {
        this.newPanel = new ProjectNewPanel(this);
        this.getContentPane().remove(this.jsp);
        this.getContentPane().add((Component)this.newPanel, "Center");
        this.back.setEnabled(true);
        this.newPanel.showed();
        ((JPanel)this.getContentPane()).revalidate();
        this.step = 1;
        this.sproject = 1;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.jt.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            this.next.setEnabled(false);
        } else {
            this.next.setEnabled(true);
        }
    }

    private class NodeAndFile {
        protected MutableTreeNode node;
        protected FileType ft;

        public NodeAndFile(MutableTreeNode mutableTreeNode, FileType fileType) {
            this.node = mutableTreeNode;
            this.ft = fileType;
        }

        public MutableTreeNode getTreeNode() {
            return this.node;
        }

        public FileType getFileType() {
            return this.ft;
        }

        public boolean checkTreeNode(MutableTreeNode mutableTreeNode) {
            return this.node.equals(mutableTreeNode);
        }

        public boolean checkFileType(FileType fileType) {
            return this.ft.equals(fileType);
        }
    }
}

