/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __PRIME_H__
#define __PRIME_H__

#include <glib-object.h>

G_BEGIN_DECLS


GType prime_type;

#define PRIME_TYPE	       prime_type
#define PRIME(obj)	      (G_TYPE_CHECK_INSTANCE_CAST ((obj), PRIME_TYPE, Prime))
#define PRIME_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), PRIME_TYPE, PrimeClass))
#define PRIME_IS(obj)	      (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PRIME_TYPE))
#define PRIME_IS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PRIME_TYPE))
#define PRIME_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), PRIME_TYPE, PrimeClass))

typedef struct _Prime         Prime;
typedef struct _PrimeClass    PrimeClass;

struct _Prime
{
	GObject parent;
};

struct _PrimeClass
{
	GObjectClass parent_class;
};

void      prime_register_type         (GTypeModule *module);

Prime    *prime_new                   (void);

gchar   **prime_lookup                (Prime *prime, const gchar *pattern);
gchar   **prime_lookup_exact          (Prime *prime, const gchar *pattern);
gchar   **prime_lookup_hybrid         (Prime *prime, const gchar *pattern);
gchar   **prime_get_label             (Prime *prime, const gchar *pattern);
gchar   **prime_preedit_convert_input (Prime *prime, const gchar *pattern);
gboolean  prime_learn_word	      (Prime *prime, 
				       const gchar *key,
				       const gchar *value,
				       const gchar *part,
				       const gchar *context,
				       const gchar *suffix,
				       const gchar *rest);

G_END_DECLS

#endif /* __PRIME_H__ */
