/*
    iwm-makedef-win32
    Copyright (C) 2006 Kazuki IWAMOTO

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


int
main (int   argc,
      char *argv[])
{
  char *p, str[1024];
  int i;
  size_t *count;

  count = malloc (argc * sizeof (size_t));
  if (!count)
    return -1;
  for (i = 1; i < argc ; i++)
    {
      p = strchr (argv[i], '=');
      if (!p || argv[i] == p)
        {
          free (count);
          return -1;
        }
      count[i] = p - argv[i];
    }
  while (fgets (str, sizeof (str) / sizeof (char), stdin))
    {
      p = str;
      while (*p != '\0')
        {
          for (i = 1; i < argc; i++)
            {
              if (strncmp (p, argv[i], count[i]) == 0)
                {
                   fputs (argv[i] + count[i] + 1, stdout);
                   p += count[i];
                   break;
                }
            }
          if (i >= argc)
            fputc (*p++, stdout);
        }
    }
  free (count);
  return 0;
}
