/*
    gcommon
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "gcommon.h"


/******************************************************************************
* GtkWidget                                                                   *
******************************************************************************/
#ifndef USE_GTK_EMULATE
# if ! GTK_CHECK_VERSION(2,14,0)
GdkWindow *
gtk_widget_get_window (GtkWidget *widget)
{
  return widget->window;
}
# endif /* not GTK_CHECK_VERSION(2,14,0) */


# if ! GTK_CHECK_VERSION(2,18,0)
void
gtk_widget_get_allocation (GtkWidget     *widget,
                           GtkAllocation *allocation)
{
  *allocation = widget->allocation;
}


void
gtk_widget_set_allocation (GtkWidget           *widget,
                           const GtkAllocation *allocation)
{
  widget->allocation = *allocation;
}


GtkStateType
gtk_widget_get_state (GtkWidget *widget)
{
  return GTK_WIDGET_STATE (widget);
}


gboolean
gtk_widget_is_toplevel (GtkWidget *widget)
{
  return GTK_WIDGET_TOPLEVEL (widget);
}


gboolean
gtk_widget_get_has_window (GtkWidget *widget)
{
  return ! GTK_WIDGET_NO_WINDOW (widget);
}


void
gtk_widget_set_has_window (GtkWidget *widget,
                           gboolean   has_window)
{
  if (has_window)
    GTK_WIDGET_UNSET_FLAGS (widget, GTK_NO_WINDOW);
  else
    GTK_WIDGET_SET_FLAGS (widget, GTK_NO_WINDOW);
}
# endif /* not GTK_CHECK_VERSION(2,18,0) */


# if ! GTK_CHECK_VERSION(2,20,0)
gboolean
gtk_widget_get_realized (GtkWidget *widget)
{
  return GTK_WIDGET_REALIZED (widget);
}


void
gtk_widget_set_realized (GtkWidget *widget,
                         gboolean   realized)
{
  if (realized)
    GTK_WIDGET_SET_FLAGS (widget, GTK_REALIZED);
  else
    GTK_WIDGET_UNSET_FLAGS (widget, GTK_REALIZED);
}


gboolean
gtk_widget_get_mapped (GtkWidget *widget)
{
  return GTK_WIDGET_MAPPED (widget);
}


void
gtk_widget_set_mapped (GtkWidget *widget,
                       gboolean   mapped)
{
  if (mapped)
    GTK_WIDGET_SET_FLAGS (widget, GTK_MAPPED);
  else
    GTK_WIDGET_UNSET_FLAGS (widget, GTK_MAPPED);
}
# endif /* not GTK_CHECK_VERSION(2,20,0) */


# if ! GTK_CHECK_VERSION(2,18,0)
gboolean
gtk_widget_get_visible (GtkWidget *widget)
{
  return GTK_WIDGET_VISIBLE (widget);
}


void
gtk_widget_set_visible (GtkWidget *widget,
                        gboolean   visible)
{
  if (visible)
    gtk_widget_show (widget);
  else
    gtk_widget_hide (widget);
}


gboolean
gtk_widget_is_drawable (GtkWidget *widget)
{
  return GTK_WIDGET_VISIBLE (widget) && GTK_WIDGET_MAPPED (widget);
}


gboolean
gtk_widget_get_sensitive (GtkWidget *widget)
{
  return GTK_WIDGET_SENSITIVE (widget);
}


gboolean gtk_widget_is_sensitive (GtkWidget *widget)
{
  return GTK_WIDGET_SENSITIVE (widget) && GTK_WIDGET_PARENT_SENSITIVE (widget);
}


gboolean
gtk_widget_get_can_focus (GtkWidget *widget)
{
  return GTK_WIDGET_CAN_FOCUS (widget);
}


void
gtk_widget_set_can_focus (GtkWidget *widget,
                          gboolean   can_focus)
{
  if (can_focus)
    GTK_WIDGET_SET_FLAGS (widget, GTK_CAN_FOCUS);
  else
    GTK_WIDGET_UNSET_FLAGS (widget, GTK_CAN_FOCUS);
}


gboolean
gtk_widget_has_focus (GtkWidget *widget)
{
  return GTK_WIDGET_HAS_FOCUS (widget);
}


gboolean
gtk_widget_get_can_default (GtkWidget *widget)
{
  return GTK_WIDGET_CAN_DEFAULT (widget);
}


void
gtk_widget_set_can_default (GtkWidget *widget,
                            gboolean   can_default)
{
  if (can_default)
    GTK_WIDGET_SET_FLAGS (widget, GTK_CAN_DEFAULT);
  else
    GTK_WIDGET_UNSET_FLAGS (widget, GTK_CAN_DEFAULT);
}


gboolean
gtk_widget_get_receives_default (GtkWidget *widget)
{
  return GTK_WIDGET_RECEIVES_DEFAULT (widget);
}


void
gtk_widget_set_receives_default (GtkWidget *widget,
                                 gboolean   receives_default)
{
  if (receives_default)
    GTK_WIDGET_SET_FLAGS (widget, GTK_RECEIVES_DEFAULT);
  else
    GTK_WIDGET_UNSET_FLAGS (widget, GTK_RECEIVES_DEFAULT);
}


gboolean
gtk_widget_has_default (GtkWidget *widget)
{
  return GTK_WIDGET_HAS_DEFAULT (widget);
}


gboolean
gtk_widget_has_grab (GtkWidget *widget)
{
  return GTK_WIDGET_HAS_GRAB (widget);
}
# endif /* not GTK_CHECK_VERSION(2,18,0) */


# if ! GTK_CHECK_VERSION(2,20,0)
gboolean
gtk_widget_has_rc_style (GtkWidget *widget)
{
  return GTK_WIDGET_RC_STYLE (widget);
}
# endif /* not GTK_CHECK_VERSION(2,20,0) */


# if ! GTK_CHECK_VERSION(2,18,0)
gboolean
gtk_widget_get_app_paintable (GtkWidget *widget)
{
  return GTK_WIDGET_APP_PAINTABLE (widget);
}


gboolean
gtk_widget_get_double_buffered (GtkWidget *widget)
{
  return GTK_WIDGET_DOUBLE_BUFFERED (widget);
}
# endif /* not GTK_CHECK_VERSION(2,18,0) */
#endif /* not USE_GTK_EMULATE */
