/*
    gcommon
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __GTK2WIDGET_H__
#define __GTK2WIDGET_H__


#include "gcommon.h"


G_BEGIN_DECLS


/******************************************************************************
* GtkWidget                                                                   *
******************************************************************************/
#ifndef USE_GTK_EMULATE
# if ! GTK_CHECK_VERSION(2,14,0)
GdkWindow *gtk_widget_get_window (GtkWidget *widget);
# endif /* not GTK_CHECK_VERSION(2,14,0) */
# if ! GTK_CHECK_VERSION(2,18,0)
void gtk_widget_get_allocation (GtkWidget *widget, GtkAllocation *allocation);
void gtk_widget_set_allocation (GtkWidget *widget, const GtkAllocation *allocation);
GtkStateType gtk_widget_get_state (GtkWidget *widget);
gboolean gtk_widget_is_toplevel (GtkWidget *widget);
gboolean gtk_widget_get_has_window (GtkWidget *widget);
void gtk_widget_set_has_window (GtkWidget *widget, gboolean has_window);
# endif /* not GTK_CHECK_VERSION(2,18,0) */
# if ! GTK_CHECK_VERSION(2,20,0)
gboolean gtk_widget_get_realized (GtkWidget *widget);
void gtk_widget_set_realized (GtkWidget *widget, gboolean realized);
gboolean gtk_widget_get_mapped (GtkWidget *widget);
void gtk_widget_set_mapped (GtkWidget *widget, gboolean mapped);
# endif /* not GTK_CHECK_VERSION(2,20,0) */
# if ! GTK_CHECK_VERSION(2,18,0)
gboolean gtk_widget_get_visible (GtkWidget *widget);
void gtk_widget_set_visible (GtkWidget *widget, gboolean visible);
gboolean gtk_widget_is_drawable (GtkWidget *widget);
gboolean gtk_widget_get_sensitive (GtkWidget *widget);
gboolean gtk_widget_is_sensitive (GtkWidget *widget);
gboolean gtk_widget_get_can_focus (GtkWidget *widget);
void gtk_widget_set_can_focus (GtkWidget *widget, gboolean can_focus);
gboolean gtk_widget_has_focus (GtkWidget *widget);
gboolean gtk_widget_get_can_default (GtkWidget *widget);
void gtk_widget_set_can_default (GtkWidget *widget, gboolean can_default);
gboolean gtk_widget_get_receives_default (GtkWidget *widget);
void gtk_widget_set_receives_default (GtkWidget *widget, gboolean receives_default);
gboolean gtk_widget_has_default (GtkWidget *widget);
# endif /* not GTK_CHECK_VERSION(2,18,0) */
# if ! GTK_CHECK_VERSION(2,20,0)
gboolean gtk_widget_has_rc_style (GtkWidget *widget);
# endif /* not GTK_CHECK_VERSION(2,20,0) */
# if ! GTK_CHECK_VERSION(2,18,0)
gboolean gtk_widget_get_app_paintable (GtkWidget *widget);
gboolean gtk_widget_get_double_buffered (GtkWidget *widget);
# endif /* not GTK_CHECK_VERSION(2,18,0) */
#endif /* not USE_GTK_EMULATE */


G_END_DECLS


#endif /* __GTK2WIDGET_H__ */
