/*
    disw32
    copyright (c) 1998-2011 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __DISW32_H__
#define __DISW32_H__


#include "gcommon/gcommon.h"


G_BEGIN_DECLS


#define DW32_TYPE_ENTRY     0x00400000
#define DW32_TYPE_EXPORT    0x00200000
#define DW32_TYPE_IMPORT    0x00100000
#define DW32_TYPE_RELATIVE  0x00000008
#define DW32_TYPE_IMMEDIATE 0x00000004
#define DW32_TYPE_OFFSET    0x00000002
#define DW32_TYPE_ARRAY     0x00000001
#define DW32_TYPE_CALL      0x00010000
#define DW32_TYPE_JMP       0x01000000
#define DW32_TYPE_DATA      0x10000000
#define DW32_STAT_UNDEF     0
#define DW32_STAT_UNKNOWN   1
#define DW32_STAT_CODE      2
#define DW32_STAT_DATA      3
#define DW32_STAT_INTER     4
#define DW32_STAT_EXPORT    5
#define DW32_STAT_IMPORT    6
#define DW32_STAT_RESOURCE  7
#define DW32_STAT_RELOC     8


typedef struct _Dw32Label
{
  gchar *name;
  gint index;
  guint type;
  guint bit;
  gsize size;
} Dw32Label;
typedef struct _Dw32Info
{
  const guint8 *image;
  gchar **separate, **comment, **mnemonic;
  guint8 *status;
  gint *belong;
  guint32 base;
  gsize size;
  GList *import;
  GList *analyse;
  GList *subroutine;
} Dw32Info;


G_END_DECLS


#endif /* __DISW32_H__ */
