/*
    swfanalyser
    copyright (c) 2008-2017 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif /* HAVE_CONFIG_H */
#include <stdio.h>
#include <stdlib.h>

int
main (int   argc,
      char *argv[])
{
  int ret = -1;
  unsigned char buf[9];
  FILE *fp;

  if (argc != 2)
    {
      fprintf (stderr,
"swfanalyser "VERSION" ("BUILD_ENVIRONMENT")\n"
"copyright (c) 2008-2017 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org\n"
"\n"
"Usage: %s swffile\n"
"\n", argv[0]);
      return -1;
    }

  fp = fopen (argv[1], "rb");
  if (!fp)
    {
      fprintf (stderr, "Error : fopen (\"%s\")\n", argv[1]);
      return -1;
    }
  if (fread (buf, sizeof (unsigned char), 9, fp) != 9)
    {
      fprintf (stderr, "Error : fread\n");
      goto final;
    }
  if (buf[0] != 'F' || buf[1] != 'W' || buf[2] != 'S')
    {
      fprintf (stderr, "Error : Header\n");
      goto final;
    }
  if (fseek (fp, (5 + (buf[8] >> 3) * 4 + 8 + 8 + 16 + 7) / 8 - 1,
                                                                SEEK_CUR) != 0)
    {
      fprintf (stderr, "Error : fseek\n");
      goto final;
    }
  while (fread (buf, sizeof (unsigned char), 2, fp) == 2)
    {
      long offset;
      unsigned tag;
      size_t size;

      offset = ftell (fp) - 2;
      tag = buf[0] >> 6 | buf[1] << 2;
      size = buf[0] & 0x3f;
      if (size >= 0x3f)
        {
          if (fread (buf, sizeof (unsigned char), 4, fp) != 4)
            {
              fprintf (stderr, "Error : fread\n");
              goto final;
            }
          size = buf[0] | buf[1] << 8 | buf[2] << 16 | buf[3] << 24;
        }
      printf ("Offset:%08lX Tag:%d Size:%08zX\n", offset, tag, size);
      if (fseek (fp, size, SEEK_CUR) != 0)
        {
          fprintf (stderr, "Error : fseek\n");
          goto final;
        }
    }
  ret = 0;
  final:
  if (fclose (fp) != 0)
    {
      fprintf (stderr, "Error : fclose\n");
      return -1;
    }
  return ret;
}
