/*
    gcommon
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __GLIBDATE_H__
#define __GLIBDATE_H__


#include "gcommon.h"


G_BEGIN_DECLS


/******************************************************************************
* Date and Time Functions                                                     *
******************************************************************************/
#ifndef G_USEC_PER_SEC
# define G_USEC_PER_SEC 1000000
#endif /* not G_USEC_PER_SEC */
#ifdef USE_GTK_EMULATE
typedef struct _GTimeVal
{
  glong tv_sec;
  glong tv_usec;
} GTimeVal;


void g_get_current_time (GTimeVal *result);
void g_usleep (gulong microseconds);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,28,0)
gint64 g_get_monotonic_time (void);
gint64 g_get_real_time (void);
#endif /* not GLIB_CHECK_VERSION(2,28,0) */


G_END_DECLS


#endif /* __GLIBDATE_H__ */
