/*
    gcommon
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __GLIBMISC_H__
#define __GLIBMISC_H__


#include "gcommon.h"


G_BEGIN_DECLS


/******************************************************************************
* Miscellaneous Utility Functions                                             *
******************************************************************************/
#ifdef USE_GTK_EMULATE
gchar *g_get_prgname (void);
void g_set_prgname (const gchar *prgname);
const gchar *g_getenv (const gchar *variable);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,4,0)
gboolean g_setenv (const gchar *variable, const gchar *value, gboolean overwrite);
void g_unsetenv (const gchar *variable);
#endif /* not GLIB_CHECK_VERSION(2,4,0) */
#ifdef USE_GTK_EMULATE
const gchar *g_get_user_name (void);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,6,0)
const gchar *g_get_user_cache_dir (void);
const gchar *g_get_user_data_dir (void);
const gchar *g_get_user_config_dir (void);
#endif /* not GLIB_CHECK_VERSION(2,6,0) */
#ifdef USE_GTK_EMULATE
const gchar *g_get_home_dir (void);
const gchar *g_get_tmp_dir (void);
gchar *g_get_current_dir (void);
gboolean g_path_is_absolute (const gchar *file);
gchar *g_path_get_basename (const gchar *file);
gchar *g_path_get_dirname (const gchar *file);
gchar *g_build_filename (const gchar *first_element, ...);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,8,0)
gchar *g_build_filenamev (gchar **args);
#endif /* not GLIB_CHECK_VERSION(2,8,0) */
#ifdef USE_GTK_EMULATE
gchar *g_build_path (const gchar *separator, const gchar *first_element, ...);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,8,0)
gchar *g_build_pathv (const gchar *separator, gchar **args);
#endif /* not GLIB_CHECK_VERSION(2,8,0) */


G_END_DECLS


#endif /* __GLIBMISC_H__ */
