/*
    gcommon
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "gcommon.h"


/******************************************************************************
* Windows Compatibility Functions                                             *
******************************************************************************/
#if defined (G_OS_WIN32) && ! GLIB_CHECK_VERSION(2,8,0)
gchar *
g_win32_locale_filename_from_utf8 (const gchar *utf8filename)
{
# if GLIB_CHECK_VERSION(2,6,0)
  return g_locale_from_utf8 (utf8filename, -1, NULL, NULL, NULL);
# else /* not GLIB_CHECK_VERSION(2,6,0) */
  return g_strdup (utf8filename);
# endif /* not GLIB_CHECK_VERSION(2,6,0) */
}
#endif /* defined (G_OS_WIN32) && ! GLIB_CHECK_VERSION(2,8,0) */
