/*
    snap
    copyright (c) 1998-2017 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __SNAP_H__
#define __SNAP_H__


#include <windows.h>
#include <tlhelp32.h>
#include <tchar.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


typedef struct _API_LIST
{
  DWORD dwAddress;
  LPSTR lpszName;
} API_LIST, *PAPI_LIST, *LPAPI_LIST;
typedef struct _DLL_LIST
{
  DWORD dwMin, dwMax;
  CHAR szModule[MAX_MODULE_NAME32 + 1];
  int nApi;
  PAPI_LIST al;
} DLL_LIST, *PDLL_LIST, *LPDLL_LIST;
typedef struct _SNAP_INFO
{
  DWORD dwSize;
  LPVOID lpExe;
  int nDll;
  PDLL_LIST dl;
} SNAP_INFO, *PSNAP_INFO, *LPSNAP_INFO;


/*  スナップショット情報を取得する
      dwProcessId,プロセスID
       lpszModule,モジュール名,NULL:アドレスとサイズが必要
    lpBaseAddress,アドレス,dwBytesが0ならばNULL
          dwBytes,サイズ,0ならばlpszModuleが有効
              RET,スナップショット情報                                      */
PSNAP_INFO WINAPI
SnapShotLoad (DWORD   dwProcessId,
              LPCTSTR lpszModule,
              LPCVOID lpBaseAddress,
              DWORD   dwBytes);


/*  スナップショット情報を保存する
         psi,スナップショット情報
    lpszFile,ファイル名
         RET,TRUE:正常終了,FALSE:エラー                                     */
BOOL WINAPI
SnapShotSave (PSNAP_INFO si,
              LPCTSTR    lpszFile);


/*  スナップショット情報を解放する
    psi,スナップショット情報                                                */
VOID WINAPI
SnapShotFree (PSNAP_INFO psi);


/*  メモリイメージをファイルに保存する
      dwProcessId,プロセスID
         lpszFile,ファイル名
       lpszModule,モジュール名,NULL:アドレスとサイズが必要
    lpBaseAddress,アドレス,dwBytesが0ならばNULL
          dwBytes,サイズ,0ならばlpszModuleが有効                            */
BOOL WINAPI
SnapShot (DWORD   dwProcessId,
          LPCTSTR lpszFile,
          LPCTSTR lpszModule,
          LPCVOID lpBaseAddress,
          DWORD   dwBytes);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __SNAP_H__ */
