/*
    gcommon
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __GLIBUNICODE_H__
#define __GLIBUNICODE_H__


#include "gcommon.h"


G_BEGIN_DECLS


/******************************************************************************
* Unicode Manipulation                                                        *
******************************************************************************/
#ifdef USE_GTK_EMULATE
# define g_unichar_validate(c) (0x00 <= (c) && (c) <= 0xff)
# define g_unichar_isalnum(c) g_ascii_isalnum(c)
# define g_unichar_isalpha(c) g_ascii_isalpha(c)
# define g_unichar_iscntrl(c) g_ascii_iscntrl(c)
# define g_unichar_isdefined(c) g_unichar_validate(c)
# define g_unichar_isdigit(c) g_ascii_isdigit(c)
# define g_unichar_isgraph(c) g_ascii_isgraph(c)
# define g_unichar_islower(c) g_ascii_islower(c)
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,14,0)
# define g_unichar_ismark(c) FALSE
#endif /* not GLIB_CHECK_VERSION(2,14,0) */
#ifdef USE_GTK_EMULATE
# define g_unichar_isprint(c) g_ascii_isprint(c)
# define g_unichar_ispunct(c) g_ascii_ispunct(c)
# define g_unichar_isspace(c) g_ascii_isspace(c)
# define g_unichar_istitle(c) FALSE
# define g_unichar_isupper(c) g_ascii_isupper(c)
# define g_unichar_isxdigit(c) g_ascii_isxdigit(c)
# define g_unichar_iswide(c) FALSE
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,12,0)
# define g_unichar_iswide_cjk(c) FALSE
#endif /* not GLIB_CHECK_VERSION(2,12,0) */
#if ! GLIB_CHECK_VERSION(2,14,0)
# define g_unichar_iszerowidth(c) FALSE
#endif /* not GLIB_CHECK_VERSION(2,14,0) */
#ifdef USE_GTK_EMULATE
# define g_unichar_toupper(c) g_ascii_toupper(c)
# define g_unichar_tolower(c) g_ascii_tolower(c)
# define g_unichar_totitle(c) (c)
# define g_unichar_digit_value(c) g_ascii_digit_value(c)
# define g_unichar_xdigit_value(c) g_ascii_xdigit_value(c)
gchar *g_utf8_next_char (const gchar *p);
gunichar g_utf8_get_char_validated (const gchar *p, gssize max_len);
gchar *g_utf8_strup (const gchar *str, gssize len);
gchar *g_utf8_strdown (const gchar *str, gssize len);
gunichar2 *g_utf8_to_utf16 (const gchar *str, glong len, glong *items_read, glong *items_written, GError **error);
gchar *g_utf16_to_utf8 (const gunichar2 *str, glong len, glong *items_read, glong *items_written, GError **error);
gint g_unichar_to_utf8 (gunichar c, gchar *outbuf);
#endif /* USE_GTK_EMULATE */


G_END_DECLS


#endif /* __GLIBUNICODE_H__ */
