/*
    gcommon
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __GLIBURI_H__
#define __GLIBURI_H__


#include "gcommon.h"


G_BEGIN_DECLS


/******************************************************************************
* URI Utilities                                                               *
******************************************************************************/
#ifndef G_URI_RESERVED_CHARS_GENERIC_DELIMITERS
# define G_URI_RESERVED_CHARS_GENERIC_DELIMITERS ":/?#[]@"
#endif /* not G_URI_RESERVED_CHARS_GENERIC_DELIMITERS */
#ifndef G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS
# define G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS "!$&'()*+,;="
#endif /* not G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS */
#ifndef G_URI_RESERVED_CHARS_ALLOWED_IN_PATH_ELEMENT
# define G_URI_RESERVED_CHARS_ALLOWED_IN_PATH_ELEMENT G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS ":@"
#endif /* not G_URI_RESERVED_CHARS_ALLOWED_IN_PATH_ELEMENT */
#ifndef G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS
# define G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS G_URI_RESERVED_CHARS_ALLOWED_IN_PATH_ELEMENT "/"
#endif /* not G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS */
#ifndef G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS
# define G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS ":"
#endif /* not G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS */
#if ! GLIB_CHECK_VERSION(2,16,0)
gchar *g_uri_parse_scheme (const gchar *uri);
gchar *g_uri_escape_string (const gchar *unescaped, const gchar *reserved_chars_allowed, gboolean allow_utf8);
gchar *g_uri_unescape_string (const gchar *escaped_string, const gchar *illegal_characters);
gchar *g_uri_unescape_segment (const gchar *escaped_string, const gchar *escaped_string_end, const gchar *illegal_characters);
#endif /* not GLIB_CHECK_VERSION(2,16,0) */


G_END_DECLS


#endif /* __GLIBURI_H__ */
