/*
 * Decompiled with CFR 0.152.
 */
package org.zuena.guiceex.binder;

import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import java.util.ArrayList;
import java.util.List;
import org.zuena.guiceex.binder.ScopedBinder;
import org.zuena.guiceex.config.Collection;
import org.zuena.guiceex.config.Entry;
import org.zuena.guiceex.exception.BindException;
import org.zuena.guiceex.provider.ListProvider;
import org.zuena.guiceex.provider.MapProvider;
import org.zuena.guiceex.util.ClassUtils;

public abstract class ToBinder
extends ScopedBinder {
    protected void bindTo(LinkedBindingBuilder binder) {
        if (this.getCollection() != null) {
            this.bindIn(this.bindCollectionProvider(binder));
            return;
        }
        if (this.getToInstance() != null) {
            binder.toInstance(this.getToInstance());
            return;
        }
        ScopedBindingBuilder builder = null;
        if (this.getToType() != null) {
            builder = binder.to(ClassUtils.cast(ClassUtils.getClazz(this.getType()), ClassUtils.getClazz(this.getToType())));
        } else if (this.getToProviderInstance() != null) {
            builder = binder.toProvider(this.getToProviderInstance());
        } else if (this.getToProviderType() != null) {
            builder = binder.to(ClassUtils.getClazz(this.getToProviderType()));
        } else {
            throw new BindException("'to' type not specified");
        }
        this.bindIn(builder);
    }

    protected ScopedBindingBuilder bindCollectionProvider(LinkedBindingBuilder binder) {
        Collection collection = this.getCollection();
        ArrayList<Entry> entries = new ArrayList<Entry>();
        MapProvider provider = null;
        entries.addAll(collection.getEntries());
        if (collection.isMap()) {
            provider = new MapProvider((List<Entry>)entries, ClassUtils.getClazz(collection.getType()));
        } else if (collection.isList()) {
            provider = ListProvider.fromList(entries, ClassUtils.getClazz(collection.getType()));
        } else {
            throw new BindException("unsupport collection type '" + collection.getType() + "'");
        }
        return binder.toProvider(provider);
    }
}

