/*
 * Decompiled with CFR 0.152.
 */
package org.zuena.guiceex.config;

import com.google.inject.AbstractModule;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuena.guiceex.provider.SystemPropertiesProvider;
import org.zuena.guiceex.scope.Scopes;
import org.zuena.guiceex.scope.ThreadLocalScope;
import org.zuena.guiceex.transaction.TransactionAttributeType;
import org.zuena.guiceex.transaction.annotation.Transactionals;

public class BundleModule
extends AbstractModule {
    private static final Log log = LogFactory.getLog(BundleModule.class);

    protected void configure() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"binding for Guiceex bundle mods...");
        }
        this.bindScopes();
        this.bindDefault();
        this.bindInterceptors();
        if (log.isDebugEnabled()) {
            log.debug((Object)"end of binding for Guiceex bundle mods...");
        }
    }

    private void bindDefault() {
        this.bind(Properties.class).annotatedWith((Annotation)Names.named((String)"system")).toProvider(SystemPropertiesProvider.class).in(Singleton.class);
    }

    private void bindScopes() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"binding bundle scopes...");
        }
        this.bindScope(ThreadLocalScope.class, Scopes.THREAD_LOCAL);
    }

    private void bindInterceptors() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"binding bundle interceptors...");
        }
        TransactionAttributeType[] transactionAttributeTypeArray = TransactionAttributeType.values();
        int n = 0;
        int n2 = transactionAttributeTypeArray.length;
        while (n < n2) {
            TransactionAttributeType propagationType = transactionAttributeTypeArray[n];
            Transactionals.bindTransactionInterceptor(this.binder(), propagationType);
            ++n;
        }
    }
}

