/*
 * Decompiled with CFR 0.152.
 */
package org.zuena.guiceex.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreateRule;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.SetNextRule;
import org.apache.commons.digester.SetPropertiesRule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuena.guiceex.binder.AnnotationBinder;
import org.zuena.guiceex.binder.BindBinder;
import org.zuena.guiceex.binder.ConstantBinder;
import org.zuena.guiceex.binder.GuiceexBinder;
import org.zuena.guiceex.binder.InterceptorBinder;
import org.zuena.guiceex.binder.NameBinder;
import org.zuena.guiceex.binder.PropertiesBinder;
import org.zuena.guiceex.binder.SpringBinder;
import org.zuena.guiceex.config.Collection;
import org.zuena.guiceex.config.Entry;
import org.zuena.guiceex.exception.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private static final Log log = LogFactory.getLog(Config.class);
    private static final Digester digester = new Digester();
    private List<GuiceexBinder> binders = new ArrayList<GuiceexBinder>();

    static {
        HashMap<String, Class> binderMap = new HashMap<String, Class>();
        binderMap.put("bind", BindBinder.class);
        binderMap.put("annotation", AnnotationBinder.class);
        binderMap.put("name", NameBinder.class);
        binderMap.put("constant", ConstantBinder.class);
        digester.addRule("guiceex-config", (Rule)new ObjectCreateRule(Config.class));
        digester.addRule("guiceex-config", (Rule)new SetPropertiesRule());
        digester.addRule("guiceex-config/binders/spring", (Rule)new ObjectCreateRule(SpringBinder.class));
        digester.addRule("guiceex-config/binders/spring", (Rule)new SetNextRule("addBinder"));
        digester.addRule("guiceex-config/binders/spring", (Rule)new SetPropertiesRule());
        digester.addRule("guiceex-config/binders/properties", (Rule)new ObjectCreateRule(PropertiesBinder.class));
        digester.addRule("guiceex-config/binders/properties", (Rule)new SetNextRule("addBinder"));
        digester.addRule("guiceex-config/binders/properties", (Rule)new SetPropertiesRule());
        for (Map.Entry b : binderMap.entrySet()) {
            digester.addRule("guiceex-config/binders/" + (String)b.getKey(), (Rule)new ObjectCreateRule((Class)b.getValue()));
            digester.addRule("guiceex-config/binders/" + (String)b.getKey(), (Rule)new SetNextRule("addBinder"));
            digester.addRule("guiceex-config/binders/" + (String)b.getKey(), (Rule)new SetPropertiesRule());
            digester.addRule("guiceex-config/binders/" + (String)b.getKey() + "/map", (Rule)new ObjectCreateRule(Collection.class));
            digester.addRule("guiceex-config/binders/" + (String)b.getKey() + "/map", (Rule)new SetNextRule("setCollection"));
            digester.addRule("guiceex-config/binders/" + (String)b.getKey() + "/map", (Rule)new SetPropertiesRule());
            digester.addRule("guiceex-config/binders/" + (String)b.getKey() + "/list", (Rule)new ObjectCreateRule(Collection.class));
            digester.addRule("guiceex-config/binders/" + (String)b.getKey() + "/list", (Rule)new SetNextRule("setCollection"));
            digester.addRule("guiceex-config/binders/" + (String)b.getKey() + "/list", (Rule)new SetPropertiesRule());
            digester.addRule("guiceex-config/binders/" + (String)b.getKey() + "/map/entry", (Rule)new ObjectCreateRule(Entry.class));
            digester.addRule("guiceex-config/binders/" + (String)b.getKey() + "/map/entry", (Rule)new SetNextRule("addEntry"));
            digester.addRule("guiceex-config/binders/" + (String)b.getKey() + "/map/entry", (Rule)new SetPropertiesRule());
            digester.addRule("guiceex-config/binders/" + (String)b.getKey() + "/list/entry", (Rule)new ObjectCreateRule(Entry.class));
            digester.addRule("guiceex-config/binders/" + (String)b.getKey() + "/list/entry", (Rule)new SetNextRule("addEntry"));
            digester.addRule("guiceex-config/binders/" + (String)b.getKey() + "/list/entry", (Rule)new SetPropertiesRule());
        }
        digester.addRule("guiceex-config/interceptors/interceptor", (Rule)new ObjectCreateRule(InterceptorBinder.class));
        digester.addRule("guiceex-config/interceptors/interceptor", (Rule)new SetNextRule("addBinder"));
        digester.addRule("guiceex-config/interceptors/interceptor", (Rule)new SetPropertiesRule());
    }

    public static Config configure(String configXMLPath) throws ConfigurationException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(configXMLPath);
        if (is == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)(String.valueOf(configXMLPath) + " not found"));
            }
            return null;
        }
        try {
            Config config = (Config)digester.parse(is);
            return config;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public List<GuiceexBinder> getBinders() {
        return this.binders;
    }

    public void addBinder(GuiceexBinder binder) {
        this.binders.add(binder);
    }
}

