/*
 * Decompiled with CFR 0.152.
 */
package org.zuena.guiceex.jpa;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.zuena.guiceex.jpa.exception.PersistenceXmlParseException;
import org.zuena.guiceex.util.StringUtils;

public class EntityManagerFactoryHolder {
    private static final Map<String, PersistenceUnit> emfs = new HashMap<String, PersistenceUnit>();

    public static void initialize() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            Handler handler = new Handler();
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/persistence.xml");
            if (is != null) {
                parser.parse(is, (DefaultHandler)handler);
            }
        }
        catch (Exception e) {
            throw new PersistenceXmlParseException(e);
        }
        if (emfs.size() == 0) {
            throw new PersistenceXmlParseException("persistence-unit not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityManagerFactory getEntityManagerFactory(String unitName, Map map) {
        String name = EntityManagerFactoryHolder.getPersistenceUnitName(unitName);
        EntityManagerFactory emf = null;
        PersistenceUnit pu = emfs.get(name);
        if (pu == null) {
            throw new IllegalArgumentException("persistence-unit name='" + name + "' is not found");
        }
        PersistenceUnit persistenceUnit = pu;
        synchronized (persistenceUnit) {
            emf = pu.getEntityManagerFactory();
            if (emf == null) {
                emf = Persistence.createEntityManagerFactory((String)name, (Map)map);
                pu.setEntityManagerFactory(emf);
            }
        }
        return emf;
    }

    public static PersistenceUnit getPersistenceUnit(String unitName) {
        return emfs.get(EntityManagerFactoryHolder.getPersistenceUnitName(unitName));
    }

    public static synchronized void closeAll() {
        for (Map.Entry<String, PersistenceUnit> entry : emfs.entrySet()) {
            EntityManagerFactory emf = entry.getValue().getEntityManagerFactory();
            if (emf == null || !emf.isOpen()) continue;
            emf.close();
        }
        emfs.clear();
    }

    private static String getPersistenceUnitName(String unitName) {
        String name = unitName;
        if (StringUtils.isEmpty(name)) {
            if (emfs.size() > 1) {
                throw new PersistenceException("unitName is requited when multiple persistence-unit defined");
            }
            name = emfs.entrySet().iterator().next().getValue().getName();
        }
        return name;
    }

    public static class PersistenceUnit {
        private String name;
        private String transactionType = null;
        private EntityManagerFactory entityManagerFactory = null;

        public EntityManagerFactory getEntityManagerFactory() {
            return this.entityManagerFactory;
        }

        public void setEntityManagerFactory(EntityManagerFactory factory) {
            this.entityManagerFactory = factory;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTransactionType() {
            return this.transactionType;
        }

        public void setTransactionType(String transactionType) {
            this.transactionType = transactionType;
        }
    }

    static class Handler
    extends DefaultHandler {
        Handler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("persistence-unit".equals(qName)) {
                PersistenceUnit pu = new PersistenceUnit();
                int index = attributes.getIndex("name");
                pu.name = attributes.getValue(index);
                index = attributes.getIndex("transaction-type");
                pu.transactionType = attributes.getValue(index);
                emfs.put(pu.name, pu);
            }
        }
    }
}

