/*
 * Decompiled with CFR 0.152.
 */
package org.zuena.guiceex.jpa;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuena.guiceex.jpa.EntityManagerFactoryHolder;
import org.zuena.guiceex.jpa.utils.JPASupportUtils;

public class EntityManagerManager {
    private static final Log log = LogFactory.getLog(EntityManagerManager.class);
    private static ThreadLocal<Map<String, EntityManager>> ems = new ThreadLocal<Map<String, EntityManager>>(){

        @Override
        protected Map<String, EntityManager> initialValue() {
            return new LinkedHashMap<String, EntityManager>();
        }
    };

    public static EntityManager createNewEntityManager(PersistenceContext pc) {
        return EntityManagerManager.createNewEntityManager(pc.unitName(), JPASupportUtils.persistencePropertiesToMap(pc.properties()));
    }

    public static EntityManager createNewEntityManager(String unitName, Map param) {
        EntityManager em = EntityManagerFactoryHolder.getEntityManagerFactory(unitName, param).createEntityManager();
        if (log.isDebugEnabled()) {
            log.debug((Object)("create new EntityManager[" + em + "] for unitName[" + unitName + "]"));
        }
        return em;
    }

    public static EntityManager getCurrentEntityManager(String unitName) {
        return ems.get().get(unitName);
    }

    public static EntityManager setCurrentEntityManager(String unitName, EntityManager newEm) {
        EntityManager oldEm = ems.get().get(unitName);
        ems.get().put(unitName, newEm);
        if (log.isDebugEnabled()) {
            log.debug((Object)("set unitName[" + unitName + "] old[" + oldEm + "] to new[" + newEm + "]"));
        }
        return oldEm;
    }

    public static void beginTransaction(String unitName) {
        EntityManager em = ems.get().get(unitName);
        if (em == null) {
            throw new UnsupportedOperationException();
        }
        assert (ems != null && !ems.get().get(unitName).getTransaction().isActive());
        em.getTransaction().begin();
        if (log.isDebugEnabled()) {
            log.debug((Object)"begin transaction");
        }
    }

    public static void commitCurrentEm(String unitName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("commit  unitName[" + unitName + "] em[" + ems.get().get(unitName) + "]"));
        }
        assert (ems.get() != null && ems.get().get(unitName).getTransaction().isActive());
        try {
            ems.get().get(unitName).getTransaction().commit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void rollbackCurrentEntityManager(String unitName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("rollback  unitName[" + unitName + "] em[" + ems.get().get(unitName) + "]"));
        }
        assert (ems.get() != null && ems.get().get(unitName).getTransaction().isActive());
        try {
            ems.get().get(unitName).getTransaction().rollback();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void closeCurrentEntityManager(String unitName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("close  unitName[" + unitName + "] em[" + ems.get().get(unitName) + "]"));
        }
        assert (ems.get() != null && ems.get().get(unitName).isOpen());
        try {
            ems.get().get(unitName).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ems.get().put(unitName, null);
    }
}

