/*
 * Decompiled with CFR 0.152.
 */
package org.zuena.guiceex.jpa.utils.statements;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuena.guiceex.jpa.utils.statements.Columns;
import org.zuena.guiceex.jpa.utils.statements.Statement;
import org.zuena.guiceex.jpa.utils.statements.Table;
import org.zuena.guiceex.util.ClassUtils;
import org.zuena.guiceex.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Select<T>
extends Statement<T> {
    private static final Log log = LogFactory.getLog(Select.class);
    private Columns<T>[] columnses;
    private Table[] tables;

    public Select(Class<T> resultType) {
        this(new Columns<T>(resultType));
    }

    public Select(Columns<T> ... columnses) {
        this.columnses = columnses;
    }

    public Select<T> from(Class entityClass) {
        return this.from(new Table(entityClass));
    }

    public Select<T> from(Table ... tables) {
        this.tables = tables;
        return this;
    }

    public List<T> getResultList(EntityManager em) {
        List l = em.createNativeQuery(this.getStatementString()).getResultList();
        ArrayList<T> results = new ArrayList<T>();
        for (Object o : l) {
            Columns<T>[] columnsArray = this.columnses;
            int n = 0;
            int n2 = columnsArray.length;
            while (n < n2) {
                Columns<T> columns = columnsArray[n];
                Object[] values = (Object[])o;
                T t = ClassUtils.newInstance(columns.getResultClass());
                int i = 0;
                while (i < values.length) {
                    try {
                        Field field = columns.getField(i);
                        field.setAccessible(true);
                        field.set(t, values[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
                results.add(t);
                ++n;
            }
        }
        return results;
    }

    public String getStatementString() {
        LinkedHashMap entityGetterNames = new LinkedHashMap();
        StringBuffer sb = new StringBuffer("SELECT\n");
        boolean first = true;
        Statement[] statementArray = this.columnses;
        int n = 0;
        int n2 = statementArray.length;
        while (n < n2) {
            Columns<T> columns = statementArray[n];
            Table table = this.getTableByAlias(columns);
            int i = 0;
            while (i < columns.columnCount()) {
                Field field = table.getField(columns.getFieldName(i));
                if (field != null) {
                    if (first) {
                        first = false;
                        sb.append('\t');
                    } else {
                        sb.append("\t,");
                    }
                    if (table.getAlias() != null) {
                        sb.append(String.valueOf(table.getAlias()) + '.');
                    }
                    String name = null;
                    Column c = field.getAnnotation(Column.class);
                    if (c != null) {
                        name = c.name();
                    }
                    if (name == null) {
                        name = columns.getColumnName(i);
                    }
                    sb.append(String.valueOf(name) + '\n');
                }
                ++i;
            }
            ++n;
        }
        sb.append("FROM\n");
        first = true;
        statementArray = this.tables;
        n = 0;
        n2 = statementArray.length;
        while (n < n2) {
            Statement table = statementArray[n];
            if (first) {
                first = false;
                sb.append("\t");
            } else {
                sb.append("\t,");
            }
            sb.append(String.valueOf(((Table)table).getTableNameWithAlias()) + '\n');
            ++n;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\n" + sb));
        }
        return sb.toString();
    }

    private Table getTableByAlias(Columns columns) {
        Table[] tableArray = this.tables;
        int n = 0;
        int n2 = tableArray.length;
        while (n < n2) {
            Table table = tableArray[n];
            String alias = columns.getAlias();
            if (!StringUtils.isEmpty(alias) && alias.equals(table.getAlias()) || columns.getResultClass().equals(table.getEntityClass())) {
                return table;
            }
            ++n;
        }
        return this.tables[0];
    }
}

