/*
 * Decompiled with CFR 0.152.
 */
package org.zuena.guiceex.jpa.utils.statements;

import java.lang.reflect.Field;
import org.zuena.guiceex.jpa.utils.SQLUtils;
import org.zuena.guiceex.jpa.utils.statements.Statement;
import org.zuena.guiceex.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table<T>
extends Statement<T> {
    private final Class<T> entityClass;
    private final String alias;

    public Table(Class<T> entityClass) {
        this(entityClass, null);
    }

    public Table(Class<T> entityClass, String alias) {
        this.entityClass = entityClass;
        this.alias = StringUtils.isEmpty(alias) ? null : alias;
    }

    public String getTableNameWithAlias() {
        StringBuffer sb = new StringBuffer(this.getTableName());
        if (this.alias != null) {
            sb.append(String.valueOf(' ') + this.alias);
        }
        return sb.toString();
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public String getTableName() {
        return SQLUtils.className2TableName(this.entityClass.getSimpleName());
    }

    public String getAlias() {
        return this.alias != null ? this.alias : this.getTableName();
    }

    public Field getField(String fieldName) {
        try {
            return this.entityClass.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            return null;
        }
    }
}

