/*
 * Decompiled with CFR 0.152.
 */
package org.zuena.guiceex.scope;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocalScopeImpl
implements Scope {
    private static final Log log = LogFactory.getLog(ThreadLocalScopeImpl.class);
    private static final ThreadLocal<Map<Key, Object>> threadLocals = new ThreadLocal<Map<Key, Object>>(){

        @Override
        protected Map<Key, Object> initialValue() {
            return new HashMap<Key, Object>();
        }
    };

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> creator) {
        return new Provider<T>(){

            public T get() {
                Map map = (Map)threadLocals.get();
                if (!map.containsKey(key)) {
                    map.put(key, creator.get());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[" + Thread.currentThread().getName() + "] registed key[" + key + "] to thread-local"));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("[" + Thread.currentThread().getName() + "] get registed key[" + key + "] from thread-local"));
                }
                return map.get(key);
            }

            public String toString() {
                return creator.toString();
            }
        };
    }

    public String toString() {
        return "Scopes.THREAD_LOCAL";
    }
}

