/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.config;

import org.zuena.guiceex.util.ClassUtils;

import com.google.inject.Injector;


/**
 * guiceex.cfg-xml&lt;entry&gt;ɑΉNXłB
 * @auther matsu@zuena.org.
 * @since 0.9.1
 */
public class Entry {
	
	private String key = null;
	private String value = null;
	private String keyType = null;
	private String valueType = null;
	public Entry() {
	}
	public String getKey() {
		return key;
	}
	public void setKey(String keyType) {
		this.key = keyType;
	}
	public String getValue() {
		return value;
	}
	public void setValue(String valueType) {
		this.value = valueType;
	}
	public void setKeyType(String keyType) {
		this.keyType = keyType;
	}
	public void setValueType(String valueType) {
		this.valueType = valueType;
	}
	public boolean isDeclaredKeyType(){
		return keyType != null;
	}
	public boolean isDeclaredValueType(){
		return valueType != null;
	}
	public Object getKeyInstance(Injector injector){
		return getInstance(injector,keyType,key);
	}
	public Object getValueyInstance(Injector injector){
		return getInstance(injector,valueType,value);
	}

	@SuppressWarnings("unchecked")
	private Object getInstance(Injector injector,String type,String value){
		if (type == null){
			return value;
		}
		
		return injector.getInstance(ClassUtils.getClazz(type));
	}
}
