/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.jpa.utils.statements;


import java.lang.reflect.Field;

import static org.zuena.guiceex.jpa.utils.SQLUtils.fieldName2columnName;

/**
 * @author matsu@zuena.org.
 */
public class Columns<T> extends Statement {

	final Class<T> resultClass;
	final Field[] fields;
	final String alias;
	
	public Columns(Class<T> resultClass) {
		this(resultClass,null);
	}
	public Columns(Class<T> resultClass,String alias) {
		this.resultClass = resultClass;
		this.fields = resultClass.getDeclaredFields();
		this.alias = alias;
		
	}

	public Field getField(int i) {
		return fields[i];
	}

	public String getFieldName(int i) {
		return getField(i).getName();
	}

	public String getColumnName(int i) {
		StringBuffer sb = new StringBuffer();
		if (alias != null){
			sb.append(alias + '.');
		}
		sb.append(fieldName2columnName(getFieldName(i)));
		return sb.toString();
	}
	
	public String getAlias(){
		return alias;
	}
	public Class<T> getResultClass() {
		return resultClass;
	}
	public int columnCount() {
		return fields.length;
	}
}
