/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.transaction.annotation;

import org.zuena.guiceex.transaction.TransactionAttributeType;
import org.zuena.guiceex.jpa.transaction.TransactionInterceptor;

import com.google.inject.Binder;
import static com.google.inject.matcher.Matchers.*;;


/**
 * {@code @}{@link Transactional}̃[eBeB[\bhNXłB
 * @auther matsu@zuena.org
 * @since 0.9.1
 */
public class Transactionals {

	/**
	 * {@code @}{@link Transactional}Ame[VCX^X쐬܂B
	 * @param propargation
	 * @param rollbackFor
	 * @return
	 */
	public static  Transactional getTransactional(final TransactionAttributeType propargation){
		return new TransactionalImpl(propargation,null,null);
	}
	
	/**
	 * {@code @}{@link Transactional}Ame[V{@link TransactionInterceptor}
	 * oCfBO܂B
	 * @param binder
	 * @param propargation
	 */
	public static void bindTransactionInterceptor(
			final Binder binder
			,final TransactionAttributeType propargation){
		
		binder.bindInterceptor(any()
							,annotatedWith(getTransactional(propargation))
							, new TransactionInterceptor(propargation));
		
	}
}
