/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex;



import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuena.guiceex.config.AutoBindingModule;
import org.zuena.guiceex.config.BundleModule;
import org.zuena.guiceex.config.Config;
import org.zuena.guiceex.exception.BindException;
import org.zuena.guiceex.exception.ConfigurationException;
import org.zuena.guiceex.impl.GuiceexInjectorImpl;

import com.google.inject.Guice;
import com.google.inject.Module;

/**
 * {@link GuiceexInjector}CX^X̃t@NgNXłB
 * 쐬{@link GuiceexInjector}CX^X̊ǗAvP[Vōsꍇ
 * {@link #createInjector(Object[])}gpA{@link InjectorFactory}ɂĊǗꍇ
 * {@link #getInjector(Object[])}gp܂B҂̃\bh́A{@link GuiceexInjector}CX^X
 * {@link InjectorFactory}<code>static</code>tB[hɔzuĊǗVOg
 * t@Ng\bhłB
 * @auther matsu@zuena.org.
 * @since 0.9.1
 */
public class InjectorFactory {

	private static Log log = LogFactory.getLog(InjectorFactory.class);
	private static GuiceexInjectorImpl injector = null;
	
	private InjectorFactory() {
	}

	/**
	 * {@link Guice#createInjector(Module[])}gpăCX^X쐬܂B
	 * <code>configs</code>́A{@link Module}CX^Xyсíj<code>guceex-cfg.xml</code>
	 * t@Cւ̃NXpX\łKv܂B
	 * <code>
	 * <![CDATA[
	 *  Object[] configs = new Object[]{
	 *  	"examples/resource/org.zuena.guiceex-cfg.xml"
	 *  	, new AbstractModule(){
	 *				protected void configure() {
	 *					...
	 *				}
	 *  	}
	 *  };
	 * 
	 *	Injector injector = InjectorFactory.getInjector(configs);
	 * ]]>
	 * </code>
	 * @param configs {@link Module}CX^Xyсíj<code>guceex-cfg.xml</code>
	 * t@Cւ̃NXpX\B͂܂Object^̔zB
	 * @return {@link GuiceexInjector}CX^X
	 * @throws ConfigurationException guceex-cfg.xml̓ǂݍ݃G[ɃX[B
	 * @throws BindException oCfBOG[ɃX[B
	 */
	public static GuiceexInjector createInjector(Object... configs)throws ConfigurationException,BindException{
		if (log.isDebugEnabled()){
			log.debug("create new instance for key=[" + configs + "]");
		}
		GuiceexInjectorImpl newInjector = new GuiceexInjectorImpl(Guice.createInjector(getModules(configs)));
		newInjector.initialize();
		return newInjector;
	}

	/**
	 * {@link #createInjector(Object...)}ō쐬{@link GuiceexInjector}CX^XA
	 * <code>static</code>tB[hɔzuĊǗVOgt@Ng\bhłB
	 * @see #createInjector(Object...) 
	 */
	public static GuiceexInjector getInjector(Object... configs)throws ConfigurationException,BindException{
		
		synchronized (InjectorFactory.class) {
			if (injector == null){
				if (log.isDebugEnabled()){
					log.debug("create new instance for key=[" + configs + "]");
				}
				injector = (GuiceexInjectorImpl) createInjector(configs);
				injector.setManaged(true);
			}
		}
		return injector;
	}
	
	/**
	 * ǗĂ{@link GuiceexInjector}CX^XI܂B
	 */
	public static void close(){
		synchronized (InjectorFactory.class) {
			if (injector != null){
				injector.closeImpl();
				injector = null;
			}
		}
	}
	
	private static List<Module> getModules(Object[] configs){
		List<Module> modules = new ArrayList<Module>();
		modules.add(new BundleModule());
		if (configs.length > 0){
			for (Object config : configs) {
				if (config instanceof Module){
					if (log.isDebugEnabled()){
						log.debug("add [" + config + "]");
					}
					modules.add(Module.class.cast(config));
				}else if (config instanceof String){
					if (log.isDebugEnabled()){
						log.debug("add Module that loaded from guiceex-cfg.xml at [" + config + "]");
					}
					modules.add(
							new AutoBindingModule(
									Config.configure(String.class.cast(config)).getBinders()));
				}else{
					throw new IllegalArgumentException(config + "is NOT instance of Module or classpath for guceex-cfg.xml");
				}
			}
		}else{
			Config config = Config.configure("guiceex-cfg.xml");
			if (config != null){
				if (log.isDebugEnabled()){
					log.debug("add Module that loaded from org.zuena.guiceex-cfg.xml at default classpath");
				}
				modules.add(new AutoBindingModule(config.getBinders()));
			}
		}
		return modules;
	}
	
}
