/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.config;


import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreateRule;
import org.apache.commons.digester.SetNextRule;
import org.apache.commons.digester.SetPropertiesRule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuena.guiceex.binder.AnnotationBinder;
import org.zuena.guiceex.binder.BindBinder;
import org.zuena.guiceex.binder.ConstantBinder;
import org.zuena.guiceex.binder.GuiceexBinder;
import org.zuena.guiceex.binder.InterceptorBinder;
import org.zuena.guiceex.binder.NameBinder;
import org.zuena.guiceex.binder.PropertiesBinder;
import org.zuena.guiceex.binder.SpringBinder;
import org.zuena.guiceex.exception.ConfigurationException;


/**
 * guiceex-configɋLqꂽoCfBOݒǂݍŁAΉ{@link GuiceexBinder}CX^X
 * 쐬܂B
 * guiceex-config̓ǂݍ݋y{@link GuiceexBinder}CX^X쐬{@link Digester}gp܂B
 * @auther matsu@zuena.org.
 * @since 0.9.1
 */
public class Config {

	private static final Log log = LogFactory.getLog(Config.class);
	private static final Digester digester = new Digester();

	
	static{

		Map<String, Class> binderMap = new HashMap<String, Class>();    
		
		binderMap.put("bind", BindBinder.class);
		binderMap.put("annotation", AnnotationBinder.class);
		binderMap.put("name", NameBinder.class);
		binderMap.put("constant", ConstantBinder.class);
		

		digester.addRule("guiceex-config", new ObjectCreateRule(Config.class));
		digester.addRule("guiceex-config", new SetPropertiesRule());	
		digester.addRule("guiceex-config/binders/spring", new ObjectCreateRule(SpringBinder.class));
		digester.addRule("guiceex-config/binders/spring", new SetNextRule("addBinder"));
		digester.addRule("guiceex-config/binders/spring", new SetPropertiesRule());	
		digester.addRule("guiceex-config/binders/properties", new ObjectCreateRule(PropertiesBinder.class));
		digester.addRule("guiceex-config/binders/properties", new SetNextRule("addBinder"));
		digester.addRule("guiceex-config/binders/properties", new SetPropertiesRule());	
	
		
		for (Map.Entry<String, Class> b : binderMap.entrySet()) {
			digester.addRule("guiceex-config/binders/" + b.getKey(), new ObjectCreateRule(b.getValue()));
			digester.addRule("guiceex-config/binders/" + b.getKey(), new SetNextRule("addBinder"));
			digester.addRule("guiceex-config/binders/" + b.getKey(), new SetPropertiesRule());	

			digester.addRule("guiceex-config/binders/" + b.getKey() + "/map", new ObjectCreateRule(Collection.class));
			digester.addRule("guiceex-config/binders/" + b.getKey() + "/map", new SetNextRule("setCollection"));
			digester.addRule("guiceex-config/binders/" + b.getKey() + "/map", new SetPropertiesRule());	
			digester.addRule("guiceex-config/binders/" + b.getKey() + "/list", new ObjectCreateRule(Collection.class));
			digester.addRule("guiceex-config/binders/" + b.getKey() + "/list", new SetNextRule("setCollection"));
			digester.addRule("guiceex-config/binders/" + b.getKey() + "/list", new SetPropertiesRule());	
			digester.addRule("guiceex-config/binders/" + b.getKey() + "/map/entry", new ObjectCreateRule(Entry.class));
			digester.addRule("guiceex-config/binders/" + b.getKey() + "/map/entry", new SetNextRule("addEntry"));
			digester.addRule("guiceex-config/binders/" + b.getKey() + "/map/entry", new SetPropertiesRule());	
			digester.addRule("guiceex-config/binders/" + b.getKey() + "/list/entry", new ObjectCreateRule(Entry.class));
			digester.addRule("guiceex-config/binders/" + b.getKey() + "/list/entry", new SetNextRule("addEntry"));
			digester.addRule("guiceex-config/binders/" + b.getKey() + "/list/entry", new SetPropertiesRule());	
		}

	
		digester.addRule("guiceex-config/interceptors/interceptor", new ObjectCreateRule(InterceptorBinder.class));
		digester.addRule("guiceex-config/interceptors/interceptor", new SetNextRule("addBinder"));
		digester.addRule("guiceex-config/interceptors/interceptor", new SetPropertiesRule());	
	}
	
	
	private List<GuiceexBinder> binders = new ArrayList<GuiceexBinder>();

	public Config() {
//		binders.add(persistanceBinder);
	}	
	/**
	 * {@link Digester}gpāA<code>configXMLPath</code>֎w肳ꂽ
	 * GuiceexRtBO{@link Config}CX^XB
	 * @param configXMLPath Guice-ExtentionRtBOւ̃pXB
	 * @return {@link Config}CX^XB
	 */
	public static Config configure(String configXMLPath)throws ConfigurationException{
		InputStream is = Thread.currentThread()
							.getContextClassLoader()
							.getResourceAsStream(configXMLPath);
		if (is == null){
			if (log.isWarnEnabled()){
				log.warn(configXMLPath + " not found");
			}
			return null;
		}
		try {
			return (Config)digester.parse(is);
		} catch (Exception e) {
			throw new ConfigurationException(e);
		}finally{
			if (is != null){
				try {
					is.close();
				} catch (IOException e) {
				}
			}
		}
	}


	public List<GuiceexBinder> getBinders() {
		return binders;
	}

	public void addBinder(GuiceexBinder binder) {
		this.binders.add(binder);
	}
}
