/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.jpa.utils;

import java.util.HashMap;
import java.util.Map;

import javax.persistence.PersistenceProperty;

import org.zuena.guiceex.jpa.EntityManagerFactoryHolder;

/**
 * JPAT|[g̃[eBeBNXłB
 * @auther matsu@zuena.org
 * @since 0.9.1
 */
public class JPASupportUtils {

	/**
	 * JPAT|[g̏s܂B
	 */
	public static void initialize(){
		EntityManagerFactoryHolder.initialize();
	}
	
	/**
	 * JPAT|[gI܂B
	 */
	public static void close(){
		EntityManagerFactoryHolder.closeAll();
	}
	
	/**
	 * {@code @}{@link PersistenceProperty}Ame[V̔z{@link Map}ɕϊ܂B
	 */
	public static Map<String, String> persistencePropertiesToMap(PersistenceProperty[] properties){
		Map<String,String> map = new HashMap<String, String>();
		for (PersistenceProperty property : properties) {
			map.put(property.name(),property.value());
		}
		return map;
	}
}

