/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.provider;


import java.util.List;

import org.zuena.guiceex.InjectorFactory;
import org.zuena.guiceex.config.Entry;
import org.zuena.guiceex.exception.ProviderException;

import com.google.inject.Injector;
import com.google.inject.Provider;

/**
 * guiceex-configŎw肳ꂽRNVCX^X񋟂{@link Provider}NXłB
 * @auther matsu@zuena.org
 * @since 0.9.1
 */
public abstract class CollectionProviderSupport<T> implements Provider{

	static protected final Injector injector = InjectorFactory.getInjector();
	protected List<Entry> entries = null;
	protected Class<T> type = null;
	
	public CollectionProviderSupport( List<Entry> entries,Class<T> type) {
		this.entries = entries;
		this.type = type;
	}

	/* (non-Javadoc)
	 * @see com.google.inject.Provider#get()
	 */
	@SuppressWarnings("unchecked")
	public T get() {
		T collection = null;
		try {
			collection = type.newInstance();
		} catch (Exception e) {
			throw new ProviderException(e);
		}
		return initCollection(collection);
	}
	
	protected abstract T initCollection(T collection);
}
